/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.partition.ChunkSerDeHelper;
import com.hazelcast.internal.partition.ChunkSupplier;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.ReplicaErrorLogger;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.impl.operationservice.TargetAware;
import com.hazelcast.spi.impl.operationservice.UrgentSystemOperation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class PartitionReplicaSyncResponse
extends AbstractPartitionOperation
implements PartitionAwareOperation,
BackupOperation,
UrgentSystemOperation,
AllowedDuringPassiveState,
TargetAware,
Versioned {
    private Collection<Operation> operations;
    private ServiceNamespace namespace;
    private long[] versions;
    private transient ChunkSerDeHelper chunkSerDeHelper;

    public PartitionReplicaSyncResponse() {
    }

    public PartitionReplicaSyncResponse(Collection<Operation> operations, Collection<ChunkSupplier> chunkSuppliers, ServiceNamespace namespace, long[] versions, boolean chunkedMigrationEnabled, int maxTotalChunkedDataInBytes, ILogger logger2, int partitionId) {
        this.operations = operations;
        this.namespace = namespace;
        this.versions = versions;
        this.chunkSerDeHelper = new ChunkSerDeHelper(logger2, partitionId, chunkSuppliers, chunkedMigrationEnabled, maxTotalChunkedDataInBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(partitionId);
        int currentReplicaIndex = partition.getReplicaIndex(PartitionReplica.from(nodeEngine.getLocalMember()));
        try {
            if (replicaIndex == currentReplicaIndex) {
                this.executeOperations();
            } else {
                this.nodeNotOwnsBackup(partition);
            }
            if (this.operations != null) {
                this.operations.clear();
            }
        }
        finally {
            this.postProcessReplicaSync(partitionService, currentReplicaIndex);
        }
    }

    private void postProcessReplicaSync(InternalPartitionServiceImpl partitionService, int currentReplicaIndex) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionReplicaManager replicaManager = partitionService.getReplicaManager();
        if (replicaIndex == currentReplicaIndex) {
            replicaManager.finalizeReplicaSync(partitionId, replicaIndex, this.namespace, this.versions);
        } else {
            replicaManager.clearReplicaSyncRequest(partitionId, this.namespace, replicaIndex);
            if (currentReplicaIndex < 0) {
                replicaManager.clearPartitionReplicaVersions(partitionId, this.namespace);
            }
        }
    }

    private void nodeNotOwnsBackup(InternalPartitionImpl partition) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        NodeEngine nodeEngine = this.getNodeEngine();
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            int currentReplicaIndex = partition.getReplicaIndex(PartitionReplica.from(nodeEngine.getLocalMember()));
            logger2.finest("This node is not backup replica of partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + " anymore. current replicaIndex=" + currentReplicaIndex);
        }
        if (this.operations != null) {
            PartitionReplica replica = partition.getReplica(replicaIndex);
            MemberImpl targetMember = null;
            if (replica != null) {
                ClusterServiceImpl clusterService = (ClusterServiceImpl)nodeEngine.getClusterService();
                targetMember = clusterService.getMember(replica.address(), replica.uuid());
            }
            WrongTargetException throwable = new WrongTargetException(nodeEngine.getLocalMember(), targetMember, partitionId, replicaIndex, this.getClass().getName());
            for (Operation op : this.operations) {
                this.prepareOperation(op);
                this.onOperationFailure(op, throwable);
            }
        }
    }

    private void executeOperations() {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (this.operations != null && !this.operations.isEmpty()) {
            this.logApplyReplicaSync(partitionId, replicaIndex);
            for (Operation op : this.operations) {
                this.prepareOperation(op);
                try {
                    OperationRunner.runDirect(op);
                }
                catch (Throwable e) {
                    this.onOperationFailure(op, e);
                    this.logException(op, e);
                }
            }
        } else {
            this.logEmptyTaskList(partitionId, replicaIndex);
        }
    }

    private void prepareOperation(Operation op) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        NodeEngine nodeEngine = this.getNodeEngine();
        ILogger opLogger = nodeEngine.getLogger(op.getClass());
        OperationResponseHandler responseHandler = OperationResponseHandlerFactory.createErrorLoggingResponseHandler(opLogger);
        op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(replicaIndex).setOperationResponseHandler(responseHandler);
    }

    private void logEmptyTaskList(int partitionId, int replicaIndex) {
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            logger2.finest("No data available for replica sync, partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ", namespace=" + this.namespace + ", versions=" + Arrays.toString(this.versions));
        }
    }

    private void logException(Operation op, Throwable e) {
        Level level;
        ILogger logger2 = this.getLogger();
        NodeEngine nodeEngine = this.getNodeEngine();
        Level level2 = level = nodeEngine.isRunning() ? Level.WARNING : Level.FINEST;
        if (logger2.isLoggable(level)) {
            logger2.log(level, "While executing " + op, e);
        }
    }

    private void logApplyReplicaSync(int partitionId, int replicaIndex) {
        ILogger logger2 = this.getLogger();
        if (logger2.isFinestEnabled()) {
            logger2.finest("Applying replica sync for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + ", namespace=" + this.namespace + ", versions=" + Arrays.toString(this.versions));
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.operations != null) {
            for (Operation op : this.operations) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t2) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t2);
        }
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    public void setTarget(Address address) {
        if (this.operations != null) {
            for (Operation op : this.operations) {
                if (!(op instanceof TargetAware)) continue;
                ((TargetAware)((Object)op)).setTarget(address);
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.namespace);
        out.writeLongArray(this.versions);
        SerializationUtil.writeNullableCollection(this.operations, out);
        this.chunkSerDeHelper.writeChunkedOperations(out);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.namespace = (ServiceNamespace)in.readObject();
        this.versions = in.readLongArray();
        this.operations = SerializationUtil.readNullableCollection(in);
        this.operations = ChunkSerDeHelper.readChunkedOperations(in, this.operations);
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", namespace=").append(this.namespace);
        sb.append(", versions=").append(Arrays.toString(this.versions));
    }

    @Override
    public int getClassId() {
        return 10;
    }
}

