/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.schema;

import com.hazelcast.cluster.Member;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.schema.AckSchemaReplicationOperation;
import com.hazelcast.internal.serialization.impl.compact.schema.MemberSchemaService;
import com.hazelcast.internal.serialization.impl.compact.schema.PrepareSchemaReplicationOperation;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplication;
import com.hazelcast.internal.serialization.impl.compact.schema.SchemaReplicationStatus;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class SchemaReplicator {
    static final int MAX_RETRIES_FOR_REQUESTS = 100;
    private final MemberSchemaService schemaService;
    private final Object mutex = new Object();
    private final ConcurrentHashMap<Long, SchemaReplication> replications = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, InternalCompletableFuture<Collection<UUID>>> inFlightOperations = new ConcurrentHashMap();
    private NodeEngine nodeEngine;
    private Executor internalAsyncExecutor;

    public SchemaReplicator(MemberSchemaService schemaService) {
        this.schemaService = schemaService;
    }

    public void init(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.internalAsyncExecutor = nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    public void clear() {
        for (InternalCompletableFuture<Collection<UUID>> future : this.inFlightOperations.values()) {
            future.completeExceptionally(new HazelcastException("The state of the SchemaReplicator is being cleared."));
        }
        this.inFlightOperations.clear();
        this.replications.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCompletableFuture<Collection<UUID>> replicate(Schema schema) {
        long schemaId = schema.getSchemaId();
        if (this.isSchemaReplicated(schemaId)) {
            return InternalCompletableFuture.newCompletedFuture(this.getCurrentMemberUuids());
        }
        InternalCompletableFuture<Collection<UUID>> future = this.inFlightOperations.get(schemaId);
        if (future != null) {
            return future;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (this.isSchemaReplicated(schemaId)) {
                return InternalCompletableFuture.newCompletedFuture(this.getCurrentMemberUuids());
            }
            future = this.inFlightOperations.get(schemaId);
            if (future != null) {
                return future;
            }
            future = new InternalCompletableFuture();
            this.inFlightOperations.put(schemaId, future);
        }
        SchemaReplication replication = this.replications.get(schemaId);
        if (replication == null) {
            this.doReplicate(schema, future);
            return future;
        }
        switch (replication.getStatus()) {
            case REPLICATED: {
                this.inFlightOperations.remove(schemaId, future);
                future.complete(this.getCurrentMemberUuids());
                break;
            }
            case PREPARED: {
                this.doReplicatePreparedSchema(schema, future);
                break;
            }
            default: {
                IllegalStateException exception = new IllegalStateException("Unexpected replication status");
                this.completeInFlightOperationExceptionally(schemaId, future, exception);
                throw exception;
            }
        }
        return future;
    }

    private boolean isSchemaReplicated(long schemaId) {
        SchemaReplication replication = this.replications.get(schemaId);
        return replication != null && replication.getStatus() == SchemaReplicationStatus.REPLICATED;
    }

    public InternalCompletableFuture<Void> replicateAll(List<Schema> schemas) {
        InternalCompletableFuture[] replications = (InternalCompletableFuture[])schemas.stream().map(this::replicate).toArray(InternalCompletableFuture[]::new);
        InternalCompletableFuture<Void> future = new InternalCompletableFuture<Void>();
        CompletableFuture.allOf(replications).whenCompleteAsync((result, throwable) -> {
            if (throwable == null) {
                future.complete(null);
            } else {
                future.completeExceptionally((Throwable)throwable);
            }
        }, this.internalAsyncExecutor);
        return future;
    }

    public void markSchemaAsPrepared(Schema schema) {
        long schemaId = schema.getSchemaId();
        SchemaReplication replication = new SchemaReplication(schema, SchemaReplicationStatus.PREPARED);
        this.replications.putIfAbsent(schemaId, replication);
    }

    public void markSchemaAsReplicated(long schemaId) {
        SchemaReplication existing = this.replications.get(schemaId);
        if (existing == null) {
            return;
        }
        existing.setStatus(SchemaReplicationStatus.REPLICATED);
    }

    public SchemaReplicationStatus getReplicationStatus(Schema schema) {
        SchemaReplication replication = this.replications.get(schema.getSchemaId());
        if (replication == null) {
            return null;
        }
        return replication.getStatus();
    }

    public Collection<SchemaReplication> getReplications() {
        return new ArrayList<SchemaReplication>(this.replications.values());
    }

    public void setReplications(Collection<SchemaReplication> replications) {
        for (SchemaReplication replication : replications) {
            long schemaId = replication.getSchema().getSchemaId();
            this.replications.put(schemaId, replication);
        }
    }

    private void doReplicate(Schema schema, InternalCompletableFuture<Collection<UUID>> future) {
        long schemaId = schema.getSchemaId();
        try {
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.prepareOnCaller(schema).thenComposeAsync(result -> {
                this.markSchemaAsPrepared(schema);
                return this.sendRequestForPreparation(schema);
            }, ConcurrencyUtil.CALLER_RUNS)).thenComposeAsync(result -> this.sendRequestForAcknowledgment(schemaId), ConcurrencyUtil.CALLER_RUNS)).thenAcceptAsync(result -> this.completeInFlightOperation(schemaId, future, (Collection<UUID>)result), ConcurrencyUtil.CALLER_RUNS)).exceptionally(throwable -> {
                this.completeInFlightOperationExceptionally(schemaId, future, (Throwable)throwable);
                return null;
            });
        }
        catch (Throwable t2) {
            this.completeInFlightOperationExceptionally(schemaId, future, t2);
        }
    }

    private InternalCompletableFuture<Void> prepareOnCaller(Schema schema) {
        this.schemaService.putLocal(schema);
        return this.schemaService.persistSchemaToHotRestartAsync(schema);
    }

    private void doReplicatePreparedSchema(Schema schema, InternalCompletableFuture<Collection<UUID>> future) {
        long schemaId = schema.getSchemaId();
        try {
            ((CompletableFuture)((CompletableFuture)this.sendRequestForPreparation(schema).thenComposeAsync(result -> this.sendRequestForAcknowledgment(schemaId), ConcurrencyUtil.CALLER_RUNS)).thenAcceptAsync(result -> this.completeInFlightOperation(schemaId, future, (Collection<UUID>)result), ConcurrencyUtil.CALLER_RUNS)).exceptionally(throwable -> {
                this.completeInFlightOperationExceptionally(schemaId, future, (Throwable)throwable);
                return null;
            });
        }
        catch (Throwable t2) {
            this.completeInFlightOperationExceptionally(schemaId, future, t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeInFlightOperation(long schemaId, InternalCompletableFuture<Collection<UUID>> future, Collection<UUID> memberUuids) {
        Object object = this.mutex;
        synchronized (object) {
            this.markSchemaAsReplicated(schemaId);
            this.inFlightOperations.remove(schemaId, future);
        }
        future.complete(memberUuids);
    }

    private void completeInFlightOperationExceptionally(long schemaId, InternalCompletableFuture<Collection<UUID>> future, Throwable t2) {
        this.inFlightOperations.remove(schemaId, future);
        future.completeExceptionally(t2);
    }

    InternalCompletableFuture<Collection<UUID>> sendRequestForPreparation(Schema schema) {
        return InvocationUtil.invokeOnStableClusterParallelExcludeLocal(this.nodeEngine, new PrepareSchemaReplicationOperationSupplier(schema, this.nodeEngine), 100);
    }

    InternalCompletableFuture<Collection<UUID>> sendRequestForAcknowledgment(long schemaId) {
        return InvocationUtil.invokeOnStableClusterParallelExcludeLocal(this.nodeEngine, new AckSchemaReplicationOperationSupplier(schemaId, this.nodeEngine), 100);
    }

    private Collection<UUID> getCurrentMemberUuids() {
        return this.nodeEngine.getClusterService().getMembers().stream().map(Member::getUuid).collect(Collectors.toList());
    }

    ConcurrentHashMap<Long, InternalCompletableFuture<Collection<UUID>>> getInFlightOperations() {
        return this.inFlightOperations;
    }

    private static final class AckSchemaReplicationOperationSupplier
    implements Supplier<Operation> {
        private final long schemaId;
        private final NodeEngine nodeEngine;

        AckSchemaReplicationOperationSupplier(long schemaId, NodeEngine nodeEngine) {
            this.schemaId = schemaId;
            this.nodeEngine = nodeEngine;
        }

        @Override
        public Operation get() {
            int memberListVersion = this.nodeEngine.getClusterService().getMemberListVersion();
            return new AckSchemaReplicationOperation(this.schemaId, memberListVersion);
        }
    }

    private static final class PrepareSchemaReplicationOperationSupplier
    implements Supplier<Operation> {
        private final Schema schema;
        private final NodeEngine nodeEngine;

        PrepareSchemaReplicationOperationSupplier(Schema schema, NodeEngine nodeEngine) {
            this.schema = schema;
            this.nodeEngine = nodeEngine;
        }

        @Override
        public Operation get() {
            int memberListVersion = this.nodeEngine.getClusterService().getMemberListVersion();
            return new PrepareSchemaReplicationOperation(this.schema, memberListVersion);
        }
    }
}

