/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Option;
import com.hazelcast.internal.tpcengine.net.AcceptRequest;
import com.hazelcast.internal.tpcengine.net.AsyncServerSocket;
import com.hazelcast.internal.tpcengine.net.AsyncServerSocketBuilder;
import com.hazelcast.internal.tpcengine.nio.NioAsyncServerSocket;
import com.hazelcast.internal.tpcengine.nio.NioAsyncServerSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.util.ExceptionUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ServerSocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class NioAsyncServerSocketBuilder
implements AsyncServerSocketBuilder {
    final NioReactor reactor;
    final ServerSocketChannel serverSocketChannel;
    final NioAsyncServerSocketOptions options;
    Consumer<AcceptRequest> acceptConsumer;
    private boolean build;

    NioAsyncServerSocketBuilder(NioReactor reactor) {
        this.reactor = reactor;
        try {
            this.serverSocketChannel = ServerSocketChannel.open();
            this.serverSocketChannel.configureBlocking(false);
            this.options = new NioAsyncServerSocketOptions(this.serverSocketChannel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public NioAsyncServerSocketBuilder setAcceptConsumer(Consumer<AcceptRequest> acceptConsumer) {
        this.verifyNotBuild();
        this.acceptConsumer = Preconditions.checkNotNull(acceptConsumer, "acceptConsumer");
        return this;
    }

    @Override
    public <T> boolean setIfSupported(Option<T> option, T value) {
        this.verifyNotBuild();
        return this.options.setIfSupported(option, value);
    }

    @Override
    public AsyncServerSocket build() {
        this.verifyNotBuild();
        if (this.acceptConsumer == null) {
            throw new IllegalStateException("acceptConsumer not configured.");
        }
        this.build = true;
        if (Thread.currentThread() == this.reactor.eventloopThread()) {
            return new NioAsyncServerSocket(this);
        }
        CompletableFuture future = new CompletableFuture();
        this.reactor.execute(() -> {
            try {
                NioAsyncServerSocket asyncServerSocket = new NioAsyncServerSocket(this);
                future.complete(asyncServerSocket);
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                throw ExceptionUtil.sneakyThrow(e);
            }
        });
        return (AsyncServerSocket)future.join();
    }

    private void verifyNotBuild() {
        if (this.build) {
            throw new IllegalStateException("Can't call build twice on the same AsyncServerSocketBuilder");
        }
    }
}

