/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    static final String EXCEPTION_SEPARATOR = "------ submitted from ------";
    private static final BiFunction<Throwable, String, HazelcastException> HAZELCAST_EXCEPTION_WRAPPER = (throwable, message) -> {
        if (message != null) {
            return new HazelcastException((String)message, (Throwable)throwable);
        }
        return new HazelcastException((Throwable)throwable);
    };

    private ExceptionUtil() {
    }

    public static String toString(Throwable cause) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        return sw.toString();
    }

    public static RuntimeException peel(Throwable t2) {
        return (RuntimeException)ExceptionUtil.peel(t2, null, null, HAZELCAST_EXCEPTION_WRAPPER);
    }

    public static <T extends Throwable> Throwable peel(Throwable t2, Class<T> allowedType, String message) {
        return ExceptionUtil.peel(t2, allowedType, message, HAZELCAST_EXCEPTION_WRAPPER);
    }

    public static <T, W extends Throwable> Throwable peel(Throwable t2, Class<T> allowedType, String message, BiFunction<Throwable, String, W> exceptionWrapper) {
        if (t2 instanceof RuntimeException) {
            return t2;
        }
        if (t2 instanceof ExecutionException || t2 instanceof InvocationTargetException) {
            Throwable cause = t2.getCause();
            if (cause != null) {
                return ExceptionUtil.peel(cause, allowedType, message, exceptionWrapper);
            }
            return (Throwable)exceptionWrapper.apply(t2, message);
        }
        if (allowedType != null && allowedType.isAssignableFrom(t2.getClass())) {
            return t2;
        }
        return (Throwable)exceptionWrapper.apply(t2, message);
    }

    public static RuntimeException rethrow(Throwable t2) {
        ExceptionUtil.rethrowIfError(t2);
        throw ExceptionUtil.peel(t2);
    }

    public static RuntimeException rethrow(Throwable t2, BiFunction<Throwable, String, RuntimeException> exceptionWrapper) {
        ExceptionUtil.rethrowIfError(t2);
        throw (RuntimeException)ExceptionUtil.peel(t2, null, null, exceptionWrapper);
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable t2, Class<T> allowedType) throws T {
        ExceptionUtil.rethrowIfError(t2);
        throw ExceptionUtil.peel(t2, allowedType, null);
    }

    public static <T extends Throwable> RuntimeException rethrowAllowedTypeFirst(Throwable t2, Class<T> allowedType) throws T {
        ExceptionUtil.rethrowIfError(t2);
        if (allowedType.isAssignableFrom(t2.getClass())) {
            throw t2;
        }
        throw ExceptionUtil.peel(t2);
    }

    public static void rethrowIfError(Throwable t2) {
        if (t2 instanceof Error) {
            if (t2 instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t2);
            }
            throw (Error)t2;
        }
    }

    public static RuntimeException rethrowAllowInterrupted(Throwable t2) throws InterruptedException {
        return ExceptionUtil.rethrow(t2, InterruptedException.class);
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t2) throws T {
        throw t2;
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger2, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return ExceptionUtil.withTryCatch(logger2, "Exception during callback", consumer);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger2, @Nonnull String message, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return (r, t2) -> {
            try {
                consumer.accept((Object)r, (Throwable)t2);
            }
            catch (Throwable e) {
                logger2.severe(message, e);
            }
        };
    }

    public static <T extends Throwable> T tryCreateExceptionWithMessageAndCause(Class<? extends Throwable> exceptionClass, String message, @Nullable Throwable cause) {
        T cloned;
        int i = 0;
        while ((cloned = ExceptionUtil.cloneException(exceptionClass, message, cause, ConstructorMethod.METHODS[i])) == null && ++i < ConstructorMethod.METHODS.length) {
        }
        return cloned;
    }

    private static <T extends Throwable> T cloneException(Class<? extends Throwable> exceptionClass, String message, @Nullable Throwable cause, ConstructorMethod constructorMethod) {
        try {
            MethodHandle constructor = MethodHandles.publicLookup().findConstructor(exceptionClass, constructorMethod.signature());
            return constructorMethod.cloneWith(constructor, message, cause);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | SecurityException | WrongMethodTypeException constructor) {
        }
        catch (Throwable t2) {
            throw new RuntimeException("Exception creation failed ", t2);
        }
        return null;
    }

    @Nonnull
    public static <T extends Throwable> T cloneExceptionWithFixedAsyncStackTrace(@Nonnull T original) {
        StackTraceElement[] fixedStackTrace = ExceptionUtil.getFixedStackTrace(original, Thread.currentThread().getStackTrace());
        Class<?> exceptionClass = original.getClass();
        T clone = ExceptionUtil.tryCreateExceptionWithMessageAndCause(exceptionClass, original.getMessage(), original.getCause());
        if (clone != null) {
            ((Throwable)clone).setStackTrace(fixedStackTrace);
            return clone;
        }
        return original;
    }

    private static StackTraceElement[] getFixedStackTrace(Throwable throwable, StackTraceElement[] localSideStackTrace) {
        StackTraceElement[] remoteStackTrace = throwable.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localSideStackTrace.length + remoteStackTrace.length];
        System.arraycopy(remoteStackTrace, 0, newStackTrace, 0, remoteStackTrace.length);
        newStackTrace[remoteStackTrace.length] = new StackTraceElement(EXCEPTION_SEPARATOR, "", "", -1);
        System.arraycopy(localSideStackTrace, 1, newStackTrace, remoteStackTrace.length + 1, localSideStackTrace.length - 1);
        return newStackTrace;
    }

    @SafeVarargs
    public static void rethrowFromCollection(Collection<?> values2, Class<? extends Throwable> ... ignored) throws Throwable {
        block0: for (Object value : values2) {
            if (!(value instanceof Throwable)) continue;
            for (Class<? extends Throwable> ignoredClass : ignored) {
                if (ignoredClass.isAssignableFrom(value.getClass())) continue block0;
            }
            throw (Throwable)value;
        }
    }

    private static enum ConstructorMethod {
        MT_INIT_STRING_THROWABLE{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE, String.class, Throwable.class);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(message, cause));
            }
        }
        ,
        MT_INIT_THROWABLE{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE, Throwable.class);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(cause));
            }
        }
        ,
        MT_INIT_STRING{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE, String.class);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                Throwable cloned = (Throwable)constructor.invokeWithArguments(message);
                try {
                    cloned.initCause(cause);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return (T)cloned;
            }
        }
        ,
        MT_INIT{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                Throwable cloned = (Throwable)constructor.invokeWithArguments(new Object[0]);
                try {
                    cloned.initCause(cause);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return (T)cloned;
            }
        };

        private static final ConstructorMethod[] METHODS;

        abstract MethodType signature();

        abstract <T extends Throwable> T cloneWith(MethodHandle var1, String var2, @Nullable Throwable var3) throws Throwable;

        static {
            METHODS = ConstructorMethod.values();
        }
    }
}

