/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.cluster.Member;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.query.QueryEventFilter;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.NodeInvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.accumulator.Accumulator;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfoSupplier;
import com.hazelcast.map.impl.querycache.subscriber.AbstractInternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.EventPublisherHelper;
import com.hazelcast.map.impl.querycache.subscriber.MapSubscriberRegistry;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEndToEndProvider;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberAccumulator;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContextSupport;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberRegistry;
import com.hazelcast.map.impl.querycache.subscriber.record.QueryCacheRecord;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.Index;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.query.impl.predicates.PredicateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class DefaultQueryCache<K, V>
extends AbstractInternalQueryCache<K, V> {
    DefaultQueryCache(String cacheId, String cacheName, QueryCacheConfig queryCacheConfig, IMap delegate, QueryCacheContext context) {
        super(cacheId, cacheName, queryCacheConfig, delegate, context);
    }

    @Override
    public void set(K key, V value, EntryEventType eventType) {
        this.setInternal(key, value, eventType, true);
    }

    @Override
    public void prepopulate(Iterator<Map.Entry<Data, Data>> entries) {
        this.recordStore.addBatch(entries, (entry, oldRecord) -> EventPublisherHelper.publishEntryEvent(this.context, this.mapName, this.cacheId, entry.getKey(), (Data)entry.getValue(), oldRecord, EntryEventType.ADDED, this.extractors));
    }

    private void setInternal(K key, V value, EntryEventType eventType, boolean doEvictionCheck) {
        QueryCacheRecord oldRecord;
        Object queryCacheKey = this.recordStore.toQueryCacheKey(key);
        Data valueData = this.toData(value);
        QueryCacheRecord queryCacheRecord = oldRecord = doEvictionCheck ? this.recordStore.add(queryCacheKey, valueData) : this.recordStore.addWithoutEvictionCheck(queryCacheKey, valueData);
        if (eventType != null) {
            EventPublisherHelper.publishEntryEvent(this.context, this.mapName, this.cacheId, queryCacheKey, valueData, oldRecord, eventType, this.extractors);
        }
    }

    @Override
    public void delete(Object key, EntryEventType eventType) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Object queryCacheKey = this.recordStore.toQueryCacheKey(key);
        QueryCacheRecord oldRecord = this.recordStore.remove(queryCacheKey);
        if (oldRecord == null) {
            return;
        }
        if (eventType != null) {
            EventPublisherHelper.publishEntryEvent(this.context, this.mapName, this.cacheId, queryCacheKey, null, oldRecord, eventType, this.extractors);
        }
    }

    @Override
    public boolean tryRecover() {
        SubscriberAccumulator subscriberAccumulator = this.getOrNullSubscriberAccumulator();
        if (subscriberAccumulator == null) {
            return false;
        }
        ConcurrentMap<Integer, Long> brokenSequences = subscriberAccumulator.getBrokenSequences();
        if (brokenSequences.isEmpty()) {
            return true;
        }
        return this.isTryRecoverSucceeded(brokenSequences);
    }

    private boolean isTryRecoverSucceeded(ConcurrentMap<Integer, Long> brokenSequences) {
        int numberOfBrokenSequences = brokenSequences.size();
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        SubscriberContextSupport subscriberContextSupport = subscriberContext.getSubscriberContextSupport();
        ArrayList futures = new ArrayList(numberOfBrokenSequences);
        for (Map.Entry entry : brokenSequences.entrySet()) {
            Integer partitionId = (Integer)entry.getKey();
            Long sequence = (Long)entry.getValue();
            Object recoveryOperation = subscriberContextSupport.createRecoveryOperation(this.mapName, this.cacheId, sequence, partitionId);
            Future future = invokerWrapper.invokeOnPartitionOwner(recoveryOperation, partitionId);
            futures.add(future);
        }
        Collection results = FutureUtil.returnWithDeadline(futures, 1L, TimeUnit.MINUTES);
        int successCount = 0;
        for (Object object : results) {
            Boolean resolvedResponse = subscriberContextSupport.resolveResponseForRecoveryOperation(object);
            if (!Boolean.TRUE.equals(resolvedResponse)) continue;
            ++successCount;
        }
        return successCount == numberOfBrokenSequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        this.removeAccumulatorInfo();
        this.removeSubscriberRegistry();
        this.removeInternalQueryCache();
        ContextMutexFactory.Mutex mutex = this.context.getLifecycleMutexFactory().mutexFor(this.mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                this.destroyRemoteResources();
                this.removeAllUserDefinedListeners();
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyRemoteResources() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        SubscriberContextSupport subscriberContextSupport = subscriberContext.getSubscriberContextSupport();
        InvokerWrapper invokerWrapper = this.context.getInvokerWrapper();
        if (invokerWrapper instanceof NodeInvokerWrapper) {
            subscriberContext.getEventService().removePublisherListener(this.mapName, this.cacheId, this.publisherListenerId);
            Collection<Member> memberList = this.context.getMemberList();
            ArrayList<Future> futures = new ArrayList<Future>(memberList.size());
            for (Member member : memberList) {
                Object removePublisher = subscriberContextSupport.createDestroyQueryCacheOperation(this.mapName, this.cacheId);
                Future future = invokerWrapper.invokeOnTarget(removePublisher, member);
                futures.add(future);
            }
            FutureUtil.waitWithDeadline(futures, 5L, TimeUnit.MINUTES);
        } else {
            try {
                subscriberContext.getEventService().removePublisherListener(this.mapName, this.cacheId, this.publisherListenerId);
            }
            finally {
                Object removePublisher = subscriberContextSupport.createDestroyQueryCacheOperation(this.mapName, this.cacheId);
                invokerWrapper.invoke(removePublisher, false);
            }
        }
    }

    private void removeAllUserDefinedListeners() {
        this.context.getQueryCacheEventService().removeAllListeners(this.mapName, this.cacheId);
    }

    private boolean removeSubscriberRegistry() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        MapSubscriberRegistry mapSubscriberRegistry = subscriberContext.getMapSubscriberRegistry();
        SubscriberRegistry subscriberRegistry = mapSubscriberRegistry.getOrNull(this.mapName);
        if (subscriberRegistry == null) {
            return true;
        }
        subscriberRegistry.remove(this.cacheId);
        return false;
    }

    private void removeAccumulatorInfo() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        AccumulatorInfoSupplier accumulatorInfoSupplier = subscriberContext.getAccumulatorInfoSupplier();
        accumulatorInfoSupplier.remove(this.mapName, this.cacheId);
    }

    private boolean removeInternalQueryCache() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        QueryCacheEndToEndProvider cacheProvider = subscriberContext.getEndToEndQueryCacheProvider();
        cacheProvider.removeSingleQueryCache(this.mapName, this.cacheName);
        this.clear();
        return subscriberContext.getQueryCacheFactory().remove(this);
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Object queryCacheKey = this.recordStore.toQueryCacheKey(key);
        return this.recordStore.containsKey(queryCacheKey);
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, "value cannot be null");
        return this.recordStore.containsValue(value);
    }

    @Override
    public V get(Object key) {
        Preconditions.checkNotNull(key, "key cannot be null");
        Object queryCacheKey = this.recordStore.toQueryCacheKey(key);
        QueryCacheRecord record = this.recordStore.get(queryCacheKey);
        if (record == null) {
            return null;
        }
        if (this.includeValue) {
            Object valueInRecord = record.getValue();
            return (V)this.toObject(valueInRecord);
        }
        return this.getDelegate().get(queryCacheKey);
    }

    @Override
    public Map<K, V> getAll(Set<K> keys2) {
        Preconditions.checkNotNull(keys2, "keys cannot be null");
        Preconditions.checkNoNullInside(keys2, "supplied key-set cannot contain null key");
        if (keys2.isEmpty()) {
            return Collections.emptyMap();
        }
        if (!this.includeValue) {
            return this.getDelegate().getAll(keys2);
        }
        Map map = MapUtil.createHashMap(keys2.size());
        for (K key : keys2) {
            Object queryCacheKey = this.recordStore.toQueryCacheKey(key);
            QueryCacheRecord record = this.recordStore.get(queryCacheKey);
            if (record == null) continue;
            Object value = this.toObject(record.getValue());
            map.put(key, value);
        }
        return map;
    }

    @Override
    public Set<K> keySet() {
        return this.keySet(Predicates.alwaysTrue());
    }

    @Override
    public Collection<V> values() {
        return this.values(Predicates.alwaysTrue());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet(Predicates.alwaysTrue());
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate cannot be null!");
        return this.scanAndGetResult(predicate, AbstractInternalQueryCache.ResultType.KEY);
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate cannot be null!");
        if (!this.includeValue) {
            return Collections.emptySet();
        }
        return this.scanAndGetResult(predicate, AbstractInternalQueryCache.ResultType.VALUE);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        Preconditions.checkNotNull(predicate, "Predicate cannot be null!");
        return this.scanAndGetResult(predicate, AbstractInternalQueryCache.ResultType.ENTRY);
    }

    @Override
    public boolean isEmpty() {
        return this.recordStore.isEmpty();
    }

    @Override
    public int size() {
        return this.recordStore.size();
    }

    @Override
    public UUID addEntryListener(MapListener listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        return this.addEntryListenerInternal(listener, null, includeValue);
    }

    @Override
    public UUID addEntryListener(MapListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        return this.addEntryListenerInternal(listener, key, includeValue);
    }

    private UUID addEntryListenerInternal(MapListener listener, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Data keyData = this.toData(key);
        EntryEventFilter filter = new EntryEventFilter(keyData, includeValue);
        QueryCacheEventService eventService = this.getEventService();
        String mapName = this.delegate.getName();
        return eventService.addListener(mapName, this.cacheId, listener, filter);
    }

    @Override
    public UUID addEntryListener(MapListener listener, Predicate<K, V> predicate, boolean includeValue) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        PredicateUtils.checkDoesNotContainPagingPredicate(predicate, "addEntryListener");
        QueryCacheEventService eventService = this.getEventService();
        QueryEventFilter filter = new QueryEventFilter(null, predicate, includeValue);
        String mapName = this.delegate.getName();
        return eventService.addListener(mapName, this.cacheId, listener, filter);
    }

    @Override
    public UUID addEntryListener(MapListener listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, "listener cannot be null");
        Preconditions.checkNotNull(predicate, "predicate cannot be null");
        Preconditions.checkNotNull(key, "key cannot be null");
        PredicateUtils.checkDoesNotContainPagingPredicate(predicate, "addEntryListener");
        QueryCacheEventService eventService = this.getEventService();
        QueryEventFilter filter = new QueryEventFilter(this.toData(key), predicate, includeValue);
        String mapName = this.delegate.getName();
        return eventService.addListener(mapName, this.cacheId, listener, filter);
    }

    @Override
    public boolean removeEntryListener(UUID id) {
        Preconditions.checkNotNull(id, "listener ID cannot be null");
        QueryCacheEventService eventService = this.getEventService();
        return eventService.removeListener(this.mapName, this.cacheId, id);
    }

    @Override
    public void addIndex(IndexConfig config) {
        Preconditions.checkNotNull(config, "Index config cannot be null.");
        assert (this.indexes.isGlobal());
        IndexConfig config0 = this.getNormalizedIndexConfig(config);
        this.indexes.addOrGetIndex(config0);
        InternalSerializationService serializationService = this.context.getSerializationService();
        CachedQueryEntry newEntry = new CachedQueryEntry(serializationService, this.extractors);
        Set<Map.Entry<Object, QueryCacheRecord>> entries = this.recordStore.entrySet();
        for (Map.Entry<Object, QueryCacheRecord> entry : entries) {
            Object queryCacheKey = entry.getKey();
            QueryCacheRecord record = entry.getValue();
            Object value = record.getValue();
            Data keyData = this.toData(queryCacheKey);
            QueryEntry queryable = new QueryEntry(serializationService, keyData, value, this.extractors);
            newEntry.init(keyData, value);
            this.indexes.putEntry(newEntry, null, queryable, Index.OperationSource.USER);
        }
    }

    @Override
    public String getName() {
        return this.cacheName;
    }

    @Override
    public IMap getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recreate() {
        ContextMutexFactory.Mutex mutex = this.context.getLifecycleMutexFactory().mutexFor(this.mapName);
        try {
            ContextMutexFactory.Mutex mutex2 = mutex;
            synchronized (mutex2) {
                SubscriberAccumulator subscriberAccumulator;
                SubscriberContext subscriberContext;
                block8: {
                    subscriberContext = this.context.getSubscriberContext();
                    subscriberAccumulator = this.getOrNullSubscriberAccumulator();
                    if (subscriberAccumulator != null) break block8;
                    return;
                }
                subscriberAccumulator.reset();
                QueryCacheRequest request = QueryCacheRequest.newQueryCacheRequest().withCacheName(this.cacheName).forMap(this.delegate).urgent(true).withContext(this.context);
                QueryCacheEndToEndProvider queryCacheEndToEndProvider = subscriberContext.getEndToEndQueryCacheProvider();
                queryCacheEndToEndProvider.tryCreateQueryCache(this.mapName, this.cacheName, subscriberContext.newEndToEndConstructor(request));
            }
        }
        finally {
            IOUtil.closeResource(mutex);
        }
    }

    private SubscriberAccumulator getOrNullSubscriberAccumulator() {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        MapSubscriberRegistry mapSubscriberRegistry = subscriberContext.getMapSubscriberRegistry();
        SubscriberRegistry subscriberRegistry = mapSubscriberRegistry.getOrNull(this.mapName);
        if (subscriberRegistry == null) {
            return null;
        }
        Accumulator accumulator = subscriberRegistry.getOrNull(this.cacheId);
        if (accumulator == null) {
            return null;
        }
        return (SubscriberAccumulator)accumulator;
    }

    @Override
    public int removeEntriesOf(int partitionId) {
        int removedEntryCount = 0;
        Set keys2 = this.recordStore.keySet();
        for (Object queryCacheKey : keys2) {
            if (this.context.getPartitionId(queryCacheKey) != partitionId || this.recordStore.remove(queryCacheKey) == null) continue;
            ++removedEntryCount;
        }
        return removedEntryCount;
    }

    public String toString() {
        return "DefaultQueryCache{mapName='" + this.mapName + '\'' + ", cacheId='" + this.cacheId + '\'' + ", cacheName='" + this.cacheName + '\'' + '}';
    }
}

