/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.merge;

import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.AbstractContainerCollector;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.merge.MergingValue;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergePolicyProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public abstract class AbstractContainerMerger<C, V, T extends MergingValue<V>>
implements Runnable {
    private static final long TIMEOUT_FACTOR = 500L;
    private static final long MINIMAL_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(5L);
    protected final AbstractContainerCollector<C> collector;
    private final Semaphore semaphore = new Semaphore(0);
    private final BiConsumer<Object, Throwable> mergeCallback;
    private final ILogger logger;
    private final OperationService operationService;
    private final SplitBrainMergePolicyProvider splitBrainMergePolicyProvider;
    private int operationCount;
    private final Executor internalAsyncExecutor;

    protected AbstractContainerMerger(AbstractContainerCollector<C> collector, NodeEngine nodeEngine) {
        this.collector = collector;
        this.logger = nodeEngine.getLogger(AbstractContainerMerger.class);
        this.mergeCallback = (response, t2) -> {
            if (t2 == null) {
                this.semaphore.release(1);
            } else {
                this.logger.warning("Error while running " + this.getLabel() + " merge operation: " + t2.getMessage());
                this.semaphore.release(1);
            }
        };
        this.operationService = nodeEngine.getOperationService();
        this.splitBrainMergePolicyProvider = nodeEngine.getSplitBrainMergePolicyProvider();
        this.internalAsyncExecutor = nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        long valueCount = this.collector.getMergingValueCount();
        if (valueCount == 0L) {
            return;
        }
        this.runInternal();
        assert (this.operationCount > 0) : "No merge operations have been invoked in AbstractContainerMerger";
        try {
            long timeoutMillis = Math.max(valueCount * 500L, MINIMAL_TIMEOUT_MILLIS);
            if (!this.semaphore.tryAcquire(this.operationCount, timeoutMillis, TimeUnit.MILLISECONDS)) {
                this.logger.warning("Split-brain healing for " + this.getLabel() + " didn't finish within the timeout...");
            }
        }
        catch (InterruptedException e) {
            this.logger.finest("Interrupted while waiting for split-brain healing of " + this.getLabel() + "...");
            Thread.currentThread().interrupt();
        }
        finally {
            this.collector.destroy();
        }
    }

    protected abstract String getLabel();

    protected abstract void runInternal();

    protected <R> SplitBrainMergePolicy<V, T, R> getMergePolicy(MergePolicyConfig mergePolicyConfig) {
        String mergePolicyName = mergePolicyConfig.getPolicy();
        return this.splitBrainMergePolicyProvider.getMergePolicy(mergePolicyName);
    }

    protected void invoke(String serviceName, Operation operation, int partitionId) {
        try {
            ++this.operationCount;
            this.operationService.invokeOnPartition(serviceName, operation, partitionId).whenCompleteAsync(this.mergeCallback, this.internalAsyncExecutor);
        }
        catch (Throwable t2) {
            throw ExceptionUtil.rethrow(t2);
        }
    }
}

