/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IndeterminateOperationState;
import com.hazelcast.core.IndeterminateOperationStateException;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.spi.impl.AbstractInvocationFuture;
import com.hazelcast.spi.impl.operationservice.WrappableException;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationConstant;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class InvocationFuture<E>
extends AbstractInvocationFuture<E> {
    final Invocation invocation;
    volatile boolean interrupted;
    private final boolean deserialize;

    InvocationFuture(Invocation invocation, boolean deserialize) {
        super(invocation.context.logger);
        this.invocation = invocation;
        this.deserialize = deserialize;
    }

    @Override
    protected void onInterruptDetected() {
        this.interrupted = true;
    }

    @Override
    public boolean isCompletedExceptionally() {
        return this.state instanceof AbstractInvocationFuture.ExceptionalResult || this.state == InvocationConstant.CALL_TIMEOUT || this.state == InvocationConstant.HEARTBEAT_TIMEOUT || this.state == InvocationConstant.INTERRUPTED;
    }

    @Override
    protected String invocationToString() {
        return this.invocation.toString();
    }

    @Override
    protected TimeoutException newTimeoutException(long timeout2, TimeUnit unit) {
        return new TimeoutException(String.format("%s failed to complete within %d %s. %s", new Object[]{this.invocation.op.getClass().getSimpleName(), timeout2, unit, this.invocation}));
    }

    @Override
    protected Exception wrapToInstanceNotActiveException(RejectedExecutionException e) {
        if (!this.invocation.context.nodeEngine.isRunning()) {
            return new HazelcastInstanceNotActiveException(e.getMessage());
        }
        return e;
    }

    @Override
    protected E resolveAndThrowIfException(Object unresolved) throws ExecutionException, InterruptedException {
        Object value = this.resolve(unresolved);
        return (E)InvocationFuture.returnOrThrowWithGetConventions(value);
    }

    public static <T> T returnOrThrowWithGetConventions(Object response) throws ExecutionException, InterruptedException {
        if (!(response instanceof AbstractInvocationFuture.ExceptionalResult)) {
            return (T)response;
        }
        if ((response = ((AbstractInvocationFuture.ExceptionalResult)response).getCause()) instanceof WrappableException) {
            response = ((WrappableException)response).wrap();
        } else if (response instanceof RuntimeException || response instanceof Error) {
            response = ExceptionUtil.cloneExceptionWithFixedAsyncStackTrace((Throwable)response);
        }
        if (response instanceof CancellationException) {
            throw (CancellationException)response;
        }
        if (response instanceof ExecutionException) {
            throw (ExecutionException)response;
        }
        if (response instanceof InterruptedException) {
            throw (InterruptedException)response;
        }
        throw new ExecutionException((Throwable)response);
    }

    @Override
    protected Object resolve(Object unresolved) {
        Throwable cause;
        if (unresolved == null) {
            return null;
        }
        if (unresolved == InvocationConstant.INTERRUPTED || unresolved == InvocationConstant.CALL_TIMEOUT || unresolved == InvocationConstant.HEARTBEAT_TIMEOUT) {
            return this.toExceptionalResult(unresolved);
        }
        if (unresolved.getClass() == Packet.class) {
            NormalResponse response = (NormalResponse)this.invocation.context.serializationService.toObject(unresolved);
            unresolved = response.getValue();
        }
        Object value = unresolved;
        if (this.deserialize && value instanceof Data && (value = this.invocation.context.serializationService.toObject(value)) == null) {
            return null;
        }
        Throwable throwable = cause = value instanceof AbstractInvocationFuture.ExceptionalResult ? ((AbstractInvocationFuture.ExceptionalResult)value).getCause() : null;
        if (this.invocation.shouldFailOnIndeterminateOperationState() && (value instanceof IndeterminateOperationState || cause instanceof IndeterminateOperationState)) {
            value = InvocationFuture.wrapThrowable(new IndeterminateOperationStateException("indeterminate operation state", cause == null ? (Throwable)value : cause));
        }
        return value;
    }

    @Override
    protected AbstractInvocationFuture.ExceptionalResult toExceptionalResult(Object object) {
        if (object == InvocationConstant.INTERRUPTED) {
            return new AbstractInvocationFuture.ExceptionalResult(new InterruptedException(this.invocation.op.getClass().getSimpleName() + " was interrupted. " + this.invocation));
        }
        if (object == InvocationConstant.CALL_TIMEOUT) {
            return new AbstractInvocationFuture.ExceptionalResult(this.newOperationTimeoutException(false));
        }
        if (object == InvocationConstant.HEARTBEAT_TIMEOUT) {
            return new AbstractInvocationFuture.ExceptionalResult(this.newOperationTimeoutException(true));
        }
        return super.toExceptionalResult(object);
    }

    private OperationTimeoutException newOperationTimeoutException(boolean heartbeatTimeout) {
        StringBuilder sb = new StringBuilder();
        if (heartbeatTimeout) {
            sb.append(this.invocation.op.getClass().getSimpleName()).append(" invocation failed to complete due to operation-heartbeat-timeout. ");
            sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
            sb.append("Start time: ").append(StringUtil.timeToString(this.invocation.firstInvocationTimeMillis)).append(". ");
            sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - this.invocation.firstInvocationTimeMillis).append(" ms. ");
            long lastHeartbeatMillis = this.invocation.lastHeartbeatMillis;
            sb.append("Last operation heartbeat: ");
            InvocationFuture.appendHeartbeat(sb, lastHeartbeatMillis);
            long lastHeartbeatFromMemberMillis = this.invocation.context.invocationMonitor.getLastMemberHeartbeatMillis(this.invocation.getTargetAddress());
            sb.append("Last operation heartbeat from member: ");
            InvocationFuture.appendHeartbeat(sb, lastHeartbeatFromMemberMillis);
        } else {
            sb.append(this.invocation.op.getClass().getSimpleName()).append(" got rejected before execution due to not starting within the operation-call-timeout of: ").append(this.invocation.callTimeoutMillis).append(" ms. ");
            sb.append("Current time: ").append(StringUtil.timeToString(Clock.currentTimeMillis())).append(". ");
            sb.append("Start time: ").append(StringUtil.timeToString(this.invocation.firstInvocationTimeMillis)).append(". ");
            sb.append("Total elapsed time: ").append(Clock.currentTimeMillis() - this.invocation.firstInvocationTimeMillis).append(" ms. ");
        }
        sb.append(this.invocation);
        String msg = sb.toString();
        return new OperationTimeoutException(msg);
    }

    private static void appendHeartbeat(StringBuilder sb, long lastHeartbeatMillis) {
        if (lastHeartbeatMillis == 0L) {
            sb.append("never. ");
        } else {
            sb.append(StringUtil.timeToString(lastHeartbeatMillis)).append(". ");
        }
    }
}

