/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl.operations;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.cluster.Address;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionReplicaVersionManager;
import com.hazelcast.internal.partition.ReplicaErrorLogger;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationexecutor.OperationRunner;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationAccessor;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;

public final class Backup
extends Operation
implements BackupOperation,
AllowedDuringPassiveState,
IdentifiedDataSerializable {
    private Address originalCaller;
    private ServiceNamespace namespace;
    private long[] replicaVersions;
    private boolean sync;
    private Operation backupOp;
    private Data backupOpData;
    private transient Throwable validationFailure;
    private transient boolean backupOperationInitialized;
    private long clientCorrelationId;

    public Backup() {
    }

    public Backup(Operation backupOp, Address originalCaller, long[] replicaVersions, boolean sync) {
        this(backupOp, originalCaller, replicaVersions, sync, -1L);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Backup(Operation backupOp, Address originalCaller, long[] replicaVersions, boolean sync, long clientCorrelationId) {
        this.backupOp = backupOp;
        this.originalCaller = originalCaller;
        this.sync = sync;
        this.replicaVersions = replicaVersions;
        if (sync && originalCaller == null) {
            throw new IllegalArgumentException("Sync backup requires original caller address, Backup operation: " + backupOp);
        }
        this.clientCorrelationId = clientCorrelationId;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Backup(Data backupOpData, Address originalCaller, long[] replicaVersions, boolean sync) {
        this(backupOpData, originalCaller, replicaVersions, sync, -1L);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Backup(Data backupOpData, Address originalCaller, long[] replicaVersions, boolean sync, long clientCorrelationId) {
        this.backupOpData = backupOpData;
        this.originalCaller = originalCaller;
        this.sync = sync;
        this.replicaVersions = replicaVersions;
        if (sync && originalCaller == null) {
            throw new IllegalArgumentException("Sync backup requires original caller address, Backup operation data: " + backupOpData);
        }
        this.clientCorrelationId = clientCorrelationId;
    }

    public Operation getBackupOp() {
        return this.backupOp;
    }

    @Override
    public void beforeRun() {
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        int partitionId = this.getPartitionId();
        InternalPartitionService partitionService = nodeEngine.getPartitionService();
        ILogger logger2 = this.getLogger();
        this.ensureBackupOperationInitialized();
        PartitionReplicaVersionManager versionManager = partitionService.getPartitionReplicaVersionManager();
        this.namespace = versionManager.getServiceNamespace(this.backupOp);
        if (!nodeEngine.getNode().getNodeExtension().isStartCompleted()) {
            this.validationFailure = new IllegalStateException("Ignoring backup! Backup operation is received before startup is completed.");
            if (logger2.isFinestEnabled()) {
                logger2.finest(this.validationFailure.getMessage());
            }
            return;
        }
        InternalPartition partition = partitionService.getPartition(partitionId);
        PartitionReplica owner = partition.getReplica(this.getReplicaIndex());
        if (owner == null || !owner.isIdentical(nodeEngine.getLocalMember())) {
            this.validationFailure = new IllegalStateException("Wrong target! " + this.toString() + " cannot be processed! Target should be: " + owner);
            if (logger2.isFinestEnabled()) {
                logger2.finest(this.validationFailure.getMessage());
            }
            return;
        }
        if (versionManager.isPartitionReplicaVersionStale(this.getPartitionId(), this.namespace, this.replicaVersions, this.getReplicaIndex())) {
            this.validationFailure = new IllegalStateException("Ignoring stale backup with namespace: " + this.namespace + ", versions: " + Arrays.toString(this.replicaVersions));
            if (logger2.isFineEnabled()) {
                long[] currentVersions = versionManager.getPartitionReplicaVersions(partitionId, this.namespace);
                logger2.fine("Ignoring stale backup! namespace: " + this.namespace + ", Current-versions: " + Arrays.toString(currentVersions) + ", Backup-versions: " + Arrays.toString(this.replicaVersions));
            }
            return;
        }
    }

    private void ensureBackupOperationInitialized() {
        if (!this.backupOperationInitialized) {
            this.backupOperationInitialized = true;
            this.backupOp.setNodeEngine(this.getNodeEngine());
            this.backupOp.setPartitionId(this.getPartitionId());
            this.backupOp.setReplicaIndex(this.getReplicaIndex());
            this.backupOp.setCallerUuid(this.getCallerUuid());
            OperationAccessor.setCallerAddress(this.backupOp, this.getCallerAddress());
            OperationAccessor.setInvocationTime(this.backupOp, Clock.currentTimeMillis());
            this.backupOp.setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        }
    }

    @Override
    public void run() throws Exception {
        if (this.validationFailure != null) {
            this.onExecutionFailure(this.validationFailure);
            return;
        }
        this.ensureBackupOperationInitialized();
        NodeEngineImpl nodeEngineImpl = (NodeEngineImpl)this.getNodeEngine();
        Set<Operation> asyncOperations = nodeEngineImpl.getOperationService().getAsyncOperations();
        OperationRunner.runDirect(this.backupOp, nodeEngineImpl, asyncOperations);
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        PartitionReplicaVersionManager versionManager = nodeEngine.getPartitionService().getPartitionReplicaVersionManager();
        versionManager.updatePartitionReplicaVersions(this.getPartitionId(), this.namespace, this.replicaVersions, this.getReplicaIndex());
    }

    @Override
    public void afterRun() throws Exception {
        if (this.validationFailure != null || !this.sync || this.getCallId() == 0L || this.originalCaller == null) {
            return;
        }
        NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
        long callId = this.getCallId();
        OperationServiceImpl operationService = nodeEngine.getOperationService();
        if (this.isCallerClient()) {
            ClientEngine clientEngine = ((NodeEngineImpl)this.getNodeEngine()).getNode().getClientEngine();
            UUID clientUUID = this.getCallerUuid();
            clientEngine.dispatchBackupEvent(clientUUID, this.clientCorrelationId);
        } else if (nodeEngine.getThisAddress().equals(this.originalCaller)) {
            operationService.getBackupHandler().notifyBackupComplete(callId);
        } else {
            operationService.getOutboundResponseHandler().sendBackupAck(this.getConnection().getConnectionManager(), this.originalCaller, callId, this.backupOp.isUrgent());
        }
    }

    private boolean isCallerClient() {
        return this.clientCorrelationId != -1L;
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.backupOp != null) {
            try {
                this.ensureBackupOperationInitialized();
                this.backupOp.onExecutionFailure(e);
            }
            catch (Throwable t2) {
                this.getLogger().warning("While calling operation.onFailure(). op: " + this.backupOp, t2);
            }
        }
    }

    @Override
    public void logError(Throwable e) {
        if (this.backupOp != null) {
            this.ensureBackupOperationInitialized();
            this.backupOp.logError(e);
        } else {
            ReplicaErrorLogger.log(e, this.getLogger());
        }
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        int k;
        if (this.backupOpData == null) {
            out.writeBoolean(false);
            out.writeObject(this.backupOp);
        } else {
            out.writeBoolean(true);
            IOUtil.writeData(out, this.backupOpData);
        }
        if (this.originalCaller == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.originalCaller.writeData(out);
        }
        int replicaVersionCount = 0;
        for (k = 0; k < this.replicaVersions.length; ++k) {
            if (this.replicaVersions[k] == 0L) continue;
            replicaVersionCount = (byte)(k + 1);
        }
        out.writeByte(replicaVersionCount);
        for (k = 0; k < replicaVersionCount; ++k) {
            out.writeLong(this.replicaVersions[k]);
        }
        out.writeBoolean(this.sync);
        out.writeLong(this.clientCorrelationId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.backupOp = in.readBoolean() ? (Operation)IOUtil.readDataAsObject(in) : (Operation)in.readObject();
        if (in.readBoolean()) {
            this.originalCaller = new Address();
            this.originalCaller.readData(in);
        }
        this.replicaVersions = new long[6];
        int replicaVersionCount = in.readByte();
        for (int k = 0; k < replicaVersionCount; ++k) {
            this.replicaVersions[k] = in.readLong();
        }
        this.sync = in.readBoolean();
        this.clientCorrelationId = in.readLong();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", backupOp=").append(this.backupOp);
        sb.append(", backupOpData=").append(this.backupOpData);
        sb.append(", originalCaller=").append(this.originalCaller);
        sb.append(", version=").append(Arrays.toString(this.replicaVersions));
        sb.append(", sync=").append(this.sync);
    }
}

