/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.basicauth;

import com.networknt.basicauth.UserAuth;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BasicAuthConfig {
    public static final String CONFIG_NAME = "basic-auth";
    private static final String ENABLED = "enabled";
    private static final String ENABLE_AD = "enableAD";
    private static final String ALLOW_ANONYMOUS = "allowAnonymous";
    private static final String ALLOW_BEARER_TOKEN = "allowBearerToken";
    private static final String USERS = "users";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String PATHS = "paths";
    public static final String ANONYMOUS = "anonymous";
    public static final String BEARER = "bearer";
    boolean enabled;
    boolean enableAD;
    boolean allowAnonymous;
    boolean allowBearerToken;
    Map<String, UserAuth> users;
    private Config config = Config.getInstance();
    private Map<String, Object> mappedConfig;

    public BasicAuthConfig() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigUser();
    }

    public BasicAuthConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigUser();
    }

    static BasicAuthConfig load() {
        return new BasicAuthConfig();
    }

    static BasicAuthConfig load(String configName) {
        return new BasicAuthConfig(configName);
    }

    void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigUser();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnableAD() {
        return this.enabled;
    }

    public void setEnableAD(boolean enabled) {
        this.enableAD = enabled;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public void setAllowAnonymous(boolean allowAnonymous) {
        this.allowAnonymous = allowAnonymous;
    }

    public boolean isAllowBearerToken() {
        return this.allowBearerToken;
    }

    public void setAllowBearerToken(boolean allowBearerToken) {
        this.allowBearerToken = allowBearerToken;
    }

    public Map<String, UserAuth> getUsers() {
        return this.users;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null && ((Boolean)object).booleanValue()) {
            this.setEnabled(true);
        }
        if ((object = this.mappedConfig.get(ENABLE_AD)) != null && ((Boolean)object).booleanValue()) {
            this.setEnableAD(true);
        }
        if ((object = this.mappedConfig.get(ALLOW_ANONYMOUS)) != null && ((Boolean)object).booleanValue()) {
            this.setAllowAnonymous(true);
        }
        if ((object = this.mappedConfig.get(ALLOW_BEARER_TOKEN)) != null && ((Boolean)object).booleanValue()) {
            this.setAllowBearerToken(true);
        }
    }

    private void setConfigUser() {
        if (this.mappedConfig.get(USERS) instanceof List) {
            List userList = (List)this.mappedConfig.get(USERS);
            this.populateUsers(userList);
        } else if (this.mappedConfig.get(USERS) instanceof String) {
            String s2 = (String)this.mappedConfig.get(USERS);
            if (!(s2 = s2.trim()).startsWith("[")) {
                throw new ConfigException("The string value must be start with [ as a JSON list");
            }
            List<Map<String, Object>> userList = JsonMapper.string2List(s2);
            this.populateUsers(userList);
        } else if (this.enabled) {
            throw new ConfigException("Basic Auth is enabled but there is no users definition.");
        }
    }

    private void populateUsers(List<Map<String, Object>> userList) {
        this.users = new HashMap<String, UserAuth>();
        userList.forEach(user -> {
            if (user instanceof Map) {
                UserAuth userAuth = new UserAuth();
                user.forEach((k, v) -> {
                    if (USERNAME.equals(k)) {
                        userAuth.setUsername((String)v);
                    }
                    if (PASSWORD.equals(k)) {
                        userAuth.setPassword((String)v);
                    }
                    if (PATHS.equals(k)) {
                        if (v instanceof List) {
                            userAuth.setPaths((List)v);
                        } else {
                            throw new ConfigException("Paths must be an array of strings.");
                        }
                    }
                });
                this.users.put(userAuth.getUsername(), userAuth);
            }
        });
    }
}

