/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.basicauth;

import com.networknt.basicauth.BasicAuthConfig;
import com.networknt.basicauth.UserAuth;
import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.ldap.LdapUtil;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicAuthHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(BasicAuthHandler.class);
    static final String BEARER_PREFIX = "BEARER";
    static final String BASIC_PREFIX = "BASIC";
    static BasicAuthConfig config;
    static final String MISSING_AUTH_TOKEN = "ERR10002";
    static final String INVALID_BASIC_HEADER = "ERR10046";
    static final String INVALID_USERNAME_OR_PASSWORD = "ERR10047";
    static final String NOT_AUTHORIZED_REQUEST_PATH = "ERR10071";
    static final String INVALID_AUTHORIZATION_HEADER = "ERR12003";
    static final String BEARER_USER_NOT_FOUND = "ERR10072";
    private volatile HttpHandler next;

    public BasicAuthHandler() {
        config = BasicAuthConfig.load();
        if (logger.isInfoEnabled()) {
            logger.info("BasicAuthHandler is loaded.");
        }
    }

    @Deprecated
    public BasicAuthHandler(BasicAuthConfig cfg) {
        config = cfg;
        if (logger.isInfoEnabled()) {
            logger.info("BasicAuthHandler is loaded.");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("BasicAuthHandler.handleRequest starts.");
        }
        String auth = exchange.getRequestHeaders().getFirst(Headers.AUTHORIZATION);
        String requestPath = exchange.getRequestPath();
        if (auth == null || auth.trim().length() == 0) {
            boolean b = this.handleAnonymousAuth(exchange, requestPath);
            if (!b) {
                return;
            }
        } else if (BASIC_PREFIX.equalsIgnoreCase(auth.substring(0, 5))) {
            if (auth.trim().length() == 5) {
                logger.error("Invalid/Unsupported authorization header {}", (Object)auth);
                this.setExchangeStatus(exchange, INVALID_AUTHORIZATION_HEADER, auth);
                exchange.endExchange();
                return;
            }
            boolean b = this.handleBasicAuth(exchange, requestPath, auth);
            if (!b) {
                return;
            }
        } else if (BEARER_PREFIX.equalsIgnoreCase(auth.substring(0, 6))) {
            boolean b = this.handleBearerToken(exchange, requestPath, auth);
            if (!b) {
                return;
            }
        } else {
            logger.error("Invalid/Unsupported authorization header {}", (Object)auth.substring(0, 10));
            this.setExchangeStatus(exchange, INVALID_AUTHORIZATION_HEADER, auth.substring(0, 10));
            exchange.endExchange();
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("BasicAuthHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    private boolean handleAnonymousAuth(HttpServerExchange exchange, String requestPath) {
        if (config.isAllowAnonymous() && config.getUsers().containsKey("anonymous")) {
            List<String> paths = config.getUsers().get("anonymous").getPaths();
            boolean match = false;
            for (String path : paths) {
                if (!requestPath.startsWith(path)) continue;
                match = true;
                break;
            }
            if (!match) {
                logger.error("Request path '{}' is not authorized for user '{}'", (Object)requestPath, (Object)"anonymous");
                exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, "Basic realm=\"Default Realm\"");
                this.setExchangeStatus(exchange, NOT_AUTHORIZED_REQUEST_PATH, requestPath, "anonymous");
                if (logger.isDebugEnabled()) {
                    logger.debug("BasicAuthHandler.handleRequest ends with an error.");
                }
                exchange.endExchange();
                return false;
            }
        } else {
            logger.error("Anonymous is not allowed and authorization header is missing.");
            exchange.getResponseHeaders().put(Headers.WWW_AUTHENTICATE, "Basic realm=\"Basic Auth\"");
            this.setExchangeStatus(exchange, MISSING_AUTH_TOKEN, new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("BasicAuthHandler.handleRequest ends with an error.");
            }
            exchange.endExchange();
            return false;
        }
        return true;
    }

    public boolean handleBasicAuth(HttpServerExchange exchange, String requestPath, String auth) {
        String credentials = auth.substring(6);
        int pos = credentials.indexOf(58);
        if (pos == -1) {
            credentials = new String(Base64.decodeBase64(credentials), StandardCharsets.UTF_8);
        }
        if ((pos = credentials.indexOf(58)) != -1) {
            UserAuth user;
            String username = credentials.substring(0, pos);
            String password = credentials.substring(pos + 1);
            if (logger.isTraceEnabled()) {
                logger.trace("input username = {}, password = {}", (Object)username, (Object)StringUtils.maskHalfString(password));
            }
            if ((user = config.getUsers().get(username)) == null) {
                logger.error("User '{}' is not found in the configuration file.", (Object)username);
                this.setExchangeStatus(exchange, INVALID_USERNAME_OR_PASSWORD, new Object[0]);
                exchange.endExchange();
                if (logger.isDebugEnabled()) {
                    logger.debug("BasicAuthHandler.handleRequest ends with an error.");
                }
                return false;
            }
            if (username.equals(user.getUsername()) && StringUtils.isEmpty(user.getPassword()) && BasicAuthHandler.config.enableAD) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Call LdapUtil with LDAP authentication and authorization for user = {}", (Object)username);
                }
                if (!BasicAuthHandler.handleLdapAuth(user, password)) {
                    this.setExchangeStatus(exchange, INVALID_USERNAME_OR_PASSWORD, new Object[0]);
                    exchange.endExchange();
                    if (logger.isDebugEnabled()) {
                        logger.debug("BasicAuthHandler.handleRequest ends with an error.");
                    }
                    return false;
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Validate basic auth based on config username {} and password {}", (Object)user.getUsername(), (Object)StringUtils.maskHalfString(user.getPassword()));
                }
                if (!user.getUsername().equals(username) || !password.equals(user.getPassword())) {
                    logger.error("Invalid username or password with authorization header = {}", (Object)StringUtils.maskHalfString(auth));
                    this.setExchangeStatus(exchange, INVALID_USERNAME_OR_PASSWORD, new Object[0]);
                    exchange.endExchange();
                    if (logger.isDebugEnabled()) {
                        logger.debug("BasicAuthHandler.handleRequest ends with an error.");
                    }
                    return false;
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Username and password validation is done for user = {}", (Object)username);
            }
            boolean match = false;
            for (String path : user.getPaths()) {
                if (!requestPath.startsWith(path)) continue;
                match = true;
                break;
            }
            if (!match) {
                logger.error("Request path '{}' is not authorized for user '{}", (Object)requestPath, (Object)user.getUsername());
                this.setExchangeStatus(exchange, NOT_AUTHORIZED_REQUEST_PATH, requestPath, user.getUsername());
                if (logger.isDebugEnabled()) {
                    logger.debug("BasicAuthHandler.handleRequest ends with an error.");
                }
                exchange.endExchange();
                return false;
            }
        } else {
            logger.error("Invalid basic authentication header. It must be username:password base64 encode.");
            this.setExchangeStatus(exchange, INVALID_BASIC_HEADER, auth.substring(0, 10));
            if (logger.isDebugEnabled()) {
                logger.debug("BasicAuthHandler.handleRequest ends with an error.");
            }
            exchange.endExchange();
            return false;
        }
        return true;
    }

    private static boolean handleLdapAuth(UserAuth user, String password) {
        boolean isAuthenticated = LdapUtil.authenticate(user.getUsername(), password);
        if (!isAuthenticated) {
            logger.error("user '" + user.getUsername() + "' Ldap authentication failed");
            return false;
        }
        return true;
    }

    private boolean handleBearerToken(HttpServerExchange exchange, String requestPath, String auth) {
        if (!BasicAuthHandler.config.allowBearerToken) {
            logger.error("Not a basic authentication header, and bearer token is not allowed.");
            this.setExchangeStatus(exchange, INVALID_BASIC_HEADER, auth.substring(0, 10));
            if (logger.isDebugEnabled()) {
                logger.debug("BasicAuthHandler.handleRequest ends with an error.");
            }
            exchange.endExchange();
            return false;
        }
        UserAuth user = config.getUsers().get("bearer");
        if (user != null) {
            List<String> paths = user.getPaths();
            boolean match = false;
            for (String path : paths) {
                if (!requestPath.startsWith(path)) continue;
                match = true;
                break;
            }
            if (!match) {
                logger.error("Request path '{}' is not authorized for user '{}' ", (Object)requestPath, (Object)"bearer");
                this.setExchangeStatus(exchange, NOT_AUTHORIZED_REQUEST_PATH, requestPath, "bearer");
                if (logger.isDebugEnabled()) {
                    logger.debug("BasicAuthHandler.handleRequest ends with an error.");
                }
                exchange.endExchange();
                return false;
            }
        } else {
            logger.error("Bearer token is allowed but missing the bearer user path definitions for authorization");
            this.setExchangeStatus(exchange, BEARER_USER_NOT_FOUND, new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("BasicAuthHandler.handleRequest ends with an error.");
            }
            exchange.endExchange();
            return false;
        }
        return true;
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ArrayList<String> masks = new ArrayList<String>();
        masks.add("password");
        ModuleRegistry.registerModule(BasicAuthHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("basic-auth"), masks);
    }

    @Override
    public void reload() {
        config = BasicAuthConfig.load();
    }
}

