/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.oauth;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.IntrospectionRequest;
import com.networknt.status.Status;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenIntrospectionRequest
extends IntrospectionRequest {
    private static Logger logger = LoggerFactory.getLogger(TokenIntrospectionRequest.class);
    private static final String CONFIG_PROPERTY_MISSING = "ERR10057";

    public TokenIntrospectionRequest(String swt) {
        this(swt, null);
    }

    public TokenIntrospectionRequest(String swt, Map<String, Object> introspectionConfig) {
        super(swt);
        Map<String, Object> clientConfig = ClientConfig.get().getMappedConfig();
        if (clientConfig != null) {
            Map oauthConfig = (Map)clientConfig.get("oauth");
            if (oauthConfig != null) {
                Map<String, Object> tokenConfig = ClientConfig.get().getTokenConfig();
                if (tokenConfig != null) {
                    this.setProxyHost((String)tokenConfig.get("proxyHost"));
                    int port = tokenConfig.get("proxyPort") == null ? 443 : (Integer)tokenConfig.get("proxyPort");
                    this.setProxyPort(port);
                    if (introspectionConfig == null) {
                        introspectionConfig = (Map)tokenConfig.get("key");
                    }
                    if (introspectionConfig != null) {
                        this.setIntrospectionOptions(introspectionConfig);
                    } else {
                        logger.error(new Status(CONFIG_PROPERTY_MISSING, "token section", "client.yml").toString());
                    }
                } else {
                    logger.error(new Status(CONFIG_PROPERTY_MISSING, "token section", "client.yml").toString());
                }
            } else {
                logger.error(new Status(CONFIG_PROPERTY_MISSING, "oauth section", "client.yml").toString());
            }
        } else {
            logger.error(new Status(CONFIG_PROPERTY_MISSING, "oauth key section", "client.yml").toString());
        }
    }

    private void setIntrospectionOptions(Map<String, Object> introspectionConfig) {
        this.setServerUrl((String)introspectionConfig.get("server_url"));
        this.setServiceId((String)introspectionConfig.get("serviceId"));
        Object object = introspectionConfig.get("enableHttp2");
        this.setEnableHttp2(object != null && (Boolean)object != false);
        this.setUri(introspectionConfig.get("uri").toString());
        if (introspectionConfig.get("client_id") != null) {
            this.setClientId((String)introspectionConfig.get("client_id"));
        }
        if (introspectionConfig.get("client_secret") != null) {
            this.setClientSecret((String)introspectionConfig.get("client_secret"));
        }
        if (introspectionConfig.get("proxyHost") != null) {
            String proxyHost = (String)introspectionConfig.get("proxyHost");
            if (proxyHost.length() > 1) {
                this.setProxyHost(proxyHost);
                int port = introspectionConfig.get("proxyPort") == null ? 443 : (Integer)introspectionConfig.get("proxyPort");
                this.setProxyPort(port);
            } else {
                this.setProxyHost(null);
                this.setProxyPort(0);
            }
        }
    }
}

