/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.client.ssl;

import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.protocols.alpn.ALPNManager;
import io.undertow.protocols.alpn.ALPNProvider;
import io.undertow.protocols.ssl.SslConduit;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.ConduitStreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.ssl.SslConnection;

public class Light4jALPNClientSelector {
    public static void runAlpn(final SslConnection sslConnection, final ChannelListener<SslConnection> fallback, final ClientCallback<ClientConnection> failedListener, ALPNClientSelector.ALPNProtocol ... details) {
        SslConduit conduit = UndertowXnioSsl.getSslConduit(sslConnection);
        final ALPNProvider provider = ALPNManager.INSTANCE.getProvider(conduit.getSSLEngine());
        if (provider == null) {
            fallback.handleEvent(sslConnection);
            return;
        }
        String[] protocols = new String[details.length];
        final HashMap<String, ALPNClientSelector.ALPNProtocol> protocolMap = new HashMap<String, ALPNClientSelector.ALPNProtocol>();
        for (int i = 0; i < protocols.length; ++i) {
            protocols[i] = details[i].getProtocol();
            protocolMap.put(details[i].getProtocol(), details[i]);
        }
        final SSLEngine sslEngine = provider.setProtocols(conduit.getSSLEngine(), protocols);
        conduit.setSslEngine(sslEngine);
        final AtomicReference<Boolean> handshakeDone = new AtomicReference<Boolean>(false);
        final AtomicReference<Boolean> connClosed = new AtomicReference<Boolean>(false);
        try {
            sslConnection.getHandshakeSetter().set((ChannelListener<? extends SslConnection>)new ChannelListener<SslConnection>(){

                @Override
                public void handleEvent(SslConnection channel) {
                    if (((Boolean)handshakeDone.get()).booleanValue()) {
                        return;
                    }
                    handshakeDone.set(true);
                }
            });
            sslConnection.getCloseSetter().set((ChannelListener<? extends SslConnection>)new ChannelListener<SslConnection>(){

                @Override
                public void handleEvent(SslConnection channel) {
                    if (((Boolean)connClosed.get()).booleanValue()) {
                        return;
                    }
                    connClosed.set(true);
                }
            });
            sslConnection.startHandshake();
            sslConnection.getSourceChannel().getReadSetter().set((ChannelListener<ConduitStreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

                @Override
                public void handleEvent(StreamSourceChannel channel) {
                    String selectedProtocol = provider.getSelectedProtocol(sslEngine);
                    if (selectedProtocol != null) {
                        this.handleSelected(selectedProtocol);
                    } else {
                        ByteBuffer buf = ByteBuffer.allocate(100);
                        try {
                            int read = channel.read(buf);
                            if (read > 0) {
                                buf.flip();
                                PushBackStreamSourceConduit pb = new PushBackStreamSourceConduit(sslConnection.getSourceChannel().getConduit());
                                pb.pushBack(new ImmediatePooled<ByteBuffer>(buf));
                                sslConnection.getSourceChannel().setConduit(pb);
                            } else if (read == -1) {
                                failedListener.failed(new ClosedChannelException());
                            }
                            selectedProtocol = provider.getSelectedProtocol(sslEngine);
                            if (selectedProtocol != null) {
                                this.handleSelected(selectedProtocol);
                            } else if (read > 0 || ((Boolean)handshakeDone.get()).booleanValue()) {
                                sslConnection.getSourceChannel().suspendReads();
                                fallback.handleEvent(sslConnection);
                                return;
                            }
                        }
                        catch (Throwable t2) {
                            IOException e = t2 instanceof IOException ? (IOException)t2 : new IOException(t2);
                            failedListener.failed(e);
                        }
                    }
                }

                private void handleSelected(String selected) {
                    if (selected.isEmpty()) {
                        sslConnection.getSourceChannel().suspendReads();
                        fallback.handleEvent(sslConnection);
                        return;
                    }
                    ALPNClientSelector.ALPNProtocol details = (ALPNClientSelector.ALPNProtocol)protocolMap.get(selected);
                    if (details == null) {
                        sslConnection.getSourceChannel().suspendReads();
                        fallback.handleEvent(sslConnection);
                        return;
                    }
                    if (((Boolean)handshakeDone.get()).booleanValue()) {
                        sslConnection.getSourceChannel().suspendReads();
                        details.getSelected().handleEvent(sslConnection);
                    } else if (((Boolean)connClosed.get()).booleanValue()) {
                        failedListener.failed(new ClosedChannelException());
                    }
                }
            });
            sslConnection.getSourceChannel().resumeReads();
        }
        catch (IOException e) {
            failedListener.failed(e);
        }
        catch (Throwable e) {
            failedListener.failed(new IOException(e));
        }
    }
}

