/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.correlation;

import com.networknt.config.Config;
import com.networknt.correlation.CorrelationConfig;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.Util;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CorrelationHandler
implements MiddlewareHandler {
    private static final Logger logger = LoggerFactory.getLogger(CorrelationHandler.class);
    private static final String CID = "cId";
    private static final String CONFIG_NAME = "correlation";
    public static CorrelationConfig config = (CorrelationConfig)Config.getInstance().getJsonObjectConfig("correlation", CorrelationConfig.class);
    private volatile HttpHandler next;

    public CorrelationHandler() {
        if (logger.isInfoEnabled()) {
            logger.info("CorrelationHandler is loaded.");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String cId;
        if (logger.isDebugEnabled()) {
            logger.debug("CorrelationHandler.handleRequest starts.");
        }
        if ((cId = exchange.getRequestHeaders().getFirst(HttpStringConstants.CORRELATION_ID)) == null && config.isAutogenCorrelationID()) {
            cId = Util.getUUID();
            exchange.getRequestHeaders().put(HttpStringConstants.CORRELATION_ID, cId);
            String tId = exchange.getRequestHeaders().getFirst(HttpStringConstants.TRACEABILITY_ID);
            if (tId != null && logger.isInfoEnabled()) {
                logger.info("Associate traceability Id " + tId + " with correlation Id " + cId);
            }
        }
        MDC.put(CID, cId);
        if (cId != null) {
            this.addHandlerMDCContext(exchange, CID, cId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CorrelationHandler.handleRequest ends.");
        }
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(CorrelationHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    @Override
    public void reload() {
        config = (CorrelationConfig)Config.getInstance().getJsonObjectConfig(CONFIG_NAME, CorrelationConfig.class);
    }
}

