/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.dump;

import com.networknt.dump.AbstractDumper;
import com.networknt.dump.DumpConfig;
import com.networknt.dump.IRequestDumpable;
import com.networknt.dump.IResponseDumpable;
import com.networknt.dump.StoreResponseStreamSinkConduit;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.mask.Mask;
import com.networknt.utility.StringUtils;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BodyDumper
extends AbstractDumper
implements IRequestDumpable,
IResponseDumpable {
    private static final Logger logger = LoggerFactory.getLogger(BodyDumper.class);
    private String bodyContent = "";

    BodyDumper(DumpConfig config, HttpServerExchange exchange) {
        super(config, exchange);
    }

    @Override
    protected void putDumpInfoTo(Map<String, Object> result) {
        if (StringUtils.isNotBlank(this.bodyContent)) {
            result.put("body", this.bodyContent);
        }
    }

    @Override
    public void dumpRequest(Map<String, Object> result) {
        String contentType = this.exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (contentType != null && contentType.startsWith("application/json")) {
            Object requestBodyAttachment = this.exchange.getAttachment(AttachmentConstants.REQUEST_BODY);
            if (requestBodyAttachment != null) {
                this.dumpBodyAttachment(requestBodyAttachment);
            } else {
                this.dumpInputStream();
            }
        } else {
            logger.info("unsupported contentType: {}", (Object)contentType);
        }
        this.putDumpInfoTo(result);
    }

    @Override
    public void dumpResponse(Map<String, Object> result) {
        byte[] responseBodyAttachment = this.exchange.getAttachment(StoreResponseStreamSinkConduit.RESPONSE);
        if (responseBodyAttachment != null) {
            this.bodyContent = this.config.isMaskEnabled() ? Mask.maskJson(new ByteArrayInputStream(responseBodyAttachment), "responseBody") : new String(responseBodyAttachment, StandardCharsets.UTF_8);
        }
        this.putDumpInfoTo(result);
    }

    private void dumpInputStream() {
        this.exchange.startBlocking();
        InputStream inputStream2 = this.exchange.getInputStream();
        try {
            if (this.config.isMaskEnabled() && inputStream2.available() != -1) {
                this.bodyContent = Mask.maskJson(inputStream2, "requestBody");
            } else {
                try {
                    this.bodyContent = StringUtils.inputStreamToString(inputStream2, StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    logger.error(e.toString());
                }
            }
        }
        catch (IOException e) {
            logger.error("undertow inputstream error:" + e.getMessage());
        }
    }

    private void dumpBodyAttachment(Object requestBodyAttachment) {
        this.bodyContent = this.config.isMaskEnabled() ? Mask.maskJson(requestBodyAttachment, "requestBody") : requestBodyAttachment.toString();
    }

    @Override
    public boolean isApplicableForRequest() {
        return this.config.isRequestBodyEnabled();
    }

    @Override
    public boolean isApplicableForResponse() {
        return this.config.isResponseBodyEnabled();
    }
}

