/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.ContentType;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.util.List;
import java.util.Map;

public interface Interceptor
extends MiddlewareHandler {
    public static final String CONTENT_TYPE_MISMATCH = "ERR10015";
    public static final char JSON_MAP_OBJECT_STARTING_CHAR = '{';
    public static final char JSON_ARRAY_OBJECT_STARTING_CHAR = '[';

    default public boolean isXmlData(String contentType) {
        return contentType.startsWith(ContentType.TEXT_PLAIN_VALUE.value()) || contentType.startsWith(ContentType.XML.value()) || contentType.startsWith(ContentType.APPLICATION_XML_VALUE.value());
    }

    default public boolean isFormData(String contentType) {
        return contentType.startsWith(ContentType.MULTIPART_FORM_DATA_VALUE.value()) || contentType.startsWith(ContentType.APPLICATION_FORM_URLENCODED_VALUE.value());
    }

    default public boolean isJsonData(String contentType) {
        return contentType.startsWith(ContentType.APPLICATION_JSON.value());
    }

    default public boolean shouldAttachBody(HeaderMap headers) {
        boolean hasContentTypeHeader = headers.getFirst(Headers.CONTENT_TYPE) != null;
        boolean hasData = false;
        if (hasContentTypeHeader) {
            String contentType = headers.getFirst(Headers.CONTENT_TYPE);
            hasData = this.isJsonData(contentType) || this.isFormData(contentType) || this.isXmlData(contentType);
        }
        return hasContentTypeHeader && hasData;
    }

    default public boolean parseJsonMapObject(HttpServerExchange ex, AttachmentKey<Object> key, String str) {
        try {
            ex.putAttachment(key, Config.getInstance().getMapper().readValue(str, new TypeReference<Map<String, Object>>(){}));
            return true;
        }
        catch (JsonProcessingException e) {
            this.setExchangeStatus(ex, CONTENT_TYPE_MISMATCH, ContentType.APPLICATION_JSON.value());
            return false;
        }
    }

    default public boolean parseJsonArrayObject(HttpServerExchange ex, AttachmentKey<Object> key, String str) {
        try {
            ex.putAttachment(key, Config.getInstance().getMapper().readValue(str, new TypeReference<List<Object>>(){}));
            return true;
        }
        catch (JsonProcessingException e) {
            this.setExchangeStatus(ex, CONTENT_TYPE_MISMATCH, ContentType.APPLICATION_JSON.value());
            return false;
        }
    }
}

