/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.config.Config;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.ContentType;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.Status;
import com.networknt.status.StatusWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LightHttpHandler
extends HttpHandler {
    public static final Logger logger = LoggerFactory.getLogger(LightHttpHandler.class);
    public static final String ERROR_NOT_DEFINED = "ERR10042";
    public static final String CONFIG_NAME = "handler";
    public static final String AUDIT_CONFIG_NAME = "audit";
    public static final String AUDIT_ON_ERROR = "auditOnError";
    public static final String AUDIT_STACK_TRACE = "auditStackTrace";
    public static final HandlerConfig config = (HandlerConfig)Config.getInstance().getJsonObjectConfig("handler", HandlerConfig.class);
    public static final Map<String, Object> auditConfig = Config.getInstance().getDefaultJsonMapConfigNoCache("audit");
    public static final boolean auditOnError;
    public static final boolean auditStackTrace;

    default public void setExchangeStatus(HttpServerExchange exchange, String code, Object ... args2) {
        Status status = new Status(code, args2);
        if (status.getStatusCode() == 0) {
            status = new Status(ERROR_NOT_DEFINED, code);
        }
        this.setExchangeStatus(exchange, status);
    }

    default public void setExchangeStatus(HttpServerExchange exchange, String code, Map<String, Object> metadata, Object ... args2) {
        Status status = new Status(code, args2);
        if (status.getStatusCode() == 0) {
            status = new Status(ERROR_NOT_DEFINED, code);
        }
        status.setMetadata(metadata);
        this.setExchangeStatus(exchange, status);
    }

    default public void setExchangeStatus(HttpServerExchange ex, Status status) {
        HashMap<String, Status> auditInfo;
        StatusWrapper statusWrapper;
        try {
            statusWrapper = SingletonServiceFactory.getBean(StatusWrapper.class);
        }
        catch (NoClassDefFoundError e) {
            statusWrapper = null;
        }
        status = statusWrapper == null ? status : statusWrapper.wrap(status, ex);
        ex.setStatusCode(status.getStatusCode());
        ex.getResponseHeaders().put(Headers.CONTENT_TYPE, ContentType.APPLICATION_JSON.value());
        status.setDescription(status.getDescription().replaceAll("\\\\", "\\\\\\\\"));
        Object[] elements = Thread.currentThread().getStackTrace();
        if (logger.isErrorEnabled()) {
            logger.error(status.toString());
        }
        if (logger.isTraceEnabled()) {
            logger.trace(Arrays.stream(elements).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
        }
        if ((auditInfo = ex.getAttachment(AttachmentConstants.AUDIT_INFO)) == null) {
            auditInfo = new HashMap<String, Status>();
            ex.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
        }
        if (auditOnError) {
            auditInfo.put("Status", status);
        }
        if (auditStackTrace) {
            auditInfo.put("StackTrace", (Status)((Object)Arrays.toString(elements)));
        }
        ex.getResponseSender().send(status.toStringConditionally());
    }

    static {
        boolean bl = auditConfig == null ? false : (auditOnError = auditConfig.get(AUDIT_ON_ERROR) != null ? (Boolean)auditConfig.get(AUDIT_ON_ERROR) : false);
        auditStackTrace = auditConfig == null ? false : (auditConfig.get(AUDIT_STACK_TRACE) != null ? (Boolean)auditConfig.get(AUDIT_ON_ERROR) : false);
    }
}

