/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.handler;

import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.ResponseInjectionConfig;
import com.networknt.handler.ResponseInterceptor;
import com.networknt.handler.conduit.ContentStreamSinkConduit;
import com.networknt.handler.conduit.ModifiableContentSinkConduit;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.conduits.StreamSinkConduit;

public class ResponseInterceptorInjectionHandler
implements MiddlewareHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseInterceptorInjectionHandler.class);
    public static final AttachmentKey<HeaderMap> ORIGINAL_ACCEPT_ENCODINGS_KEY = AttachmentKey.create(HeaderMap.class);
    private ResponseInterceptor[] interceptors = null;
    private volatile HttpHandler next;
    private static ResponseInjectionConfig config;

    public ResponseInterceptorInjectionHandler() throws Exception {
        config = ResponseInjectionConfig.load();
        this.interceptors = SingletonServiceFactory.getBeans(ResponseInterceptor.class);
        LOG.info("SinkConduitInjectorHandler is loaded!");
    }

    @Deprecated
    public ResponseInterceptorInjectionHandler(ResponseInjectionConfig cfg) throws Exception {
        config = cfg;
        LOG.info("SinkConduitInjectorHandler is loaded!");
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(ResponseInjectionConfig.class.getName(), config.getMappedConfig(), null);
    }

    @Override
    public void reload() {
        config.reload();
        if (LOG.isTraceEnabled()) {
            LOG.trace("response-injection.yml is reloaded");
        }
        ModuleRegistry.registerModule(ResponseInjectionConfig.class.getName(), config.getMappedConfig(), null);
    }

    private void forceIdentityEncodingForInterceptors(HttpServerExchange exchange) {
        if (this.interceptorsRequireContent()) {
            HeaderMap before = new HeaderMap();
            if (exchange.getRequestHeaders().contains(Headers.ACCEPT_ENCODING)) {
                exchange.getRequestHeaders().get(Headers.ACCEPT_ENCODING).forEach(value -> before.add(Headers.ACCEPT_ENCODING, (String)value));
            }
            exchange.putAttachment(ORIGINAL_ACCEPT_ENCODINGS_KEY, before);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} setting encoding to identity because request involves response interceptors.", (Object)before);
            }
            exchange.getRequestHeaders().put(Headers.ACCEPT_ENCODING, "identity");
        }
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        exchange.addResponseWrapper((factory2, currentExchange) -> {
            if (this.requiresContentSinkConduit(exchange)) {
                ModifiableContentSinkConduit mcsc = new ModifiableContentSinkConduit((StreamSinkConduit)factory2.create(), currentExchange);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("created a ModifiableContentSinkConduit instance " + mcsc);
                }
                return mcsc;
            }
            return new ContentStreamSinkConduit((StreamSinkConduit)factory2.create(), currentExchange);
        });
        Handler.next(exchange, this.next);
    }

    private boolean isCompressed(HttpServerExchange exchange) {
        HeaderValues contentEncodings = exchange.getResponseHeaders().get("Content-Encoding");
        if (contentEncodings != null) {
            for (String values2 : contentEncodings) {
                if (!this.hasCompressionFormat(values2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean requiresContentSinkConduit(HttpServerExchange exchange) {
        return this.interceptorsRequireContent() && this.isAppliedBodyInjectionPathPrefix(exchange.getRequestPath()) && !this.isCompressed(exchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAppliedBodyInjectionPathPrefix(String requestPath) {
        if (config.getAppliedBodyInjectionPathPrefixes() == null) return false;
        if (!config.getAppliedBodyInjectionPathPrefixes().stream().anyMatch(requestPath::startsWith)) return false;
        return true;
    }

    private boolean hasCompressionFormat(String values2) {
        return Arrays.stream(values2.split(",")).anyMatch(v -> Headers.GZIP.toString().equals(v) || Headers.COMPRESS.toString().equals(v) || Headers.DEFLATE.toString().equals(v));
    }

    private boolean interceptorsRequireContent() {
        return this.interceptors != null && Arrays.stream(this.interceptors).anyMatch(ri -> ri.isRequiredContent());
    }
}

