/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.jaeger.tracing;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.jaeger.tracing.JaegerConfig;
import com.networknt.jaeger.tracing.JaegerStartupHookProvider;
import com.networknt.server.Server;
import com.networknt.utility.ModuleRegistry;
import com.networknt.utility.NetUtils;
import io.jaegertracing.internal.JaegerTracer;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HttpString;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaegerHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(JaegerHandler.class);
    static JaegerConfig jaegerConfig = (JaegerConfig)Config.getInstance().getJsonObjectConfig("jaeger-tracing", JaegerConfig.class);
    private volatile HttpHandler next;

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        JaegerTracer.SpanBuilder spanBuilder;
        Map auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
        Object endpoint = null;
        endpoint = auditInfo != null ? (String)auditInfo.get("endpoint") : exchange.getRequestPath() + "@" + exchange.getRequestMethod();
        HeaderMap headerMap = exchange.getRequestHeaders();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (HttpString key : headerMap.getHeaderNames()) {
            headers.put(key.toString(), headerMap.getFirst(key));
        }
        TextMapAdapter carrier = new TextMapAdapter(headers);
        try {
            SpanContext parentSpanCtx = JaegerStartupHookProvider.tracer.extract((Format)Format.Builtin.HTTP_HEADERS, carrier);
            spanBuilder = parentSpanCtx == null ? JaegerStartupHookProvider.tracer.buildSpan((String)endpoint) : JaegerStartupHookProvider.tracer.buildSpan((String)endpoint).asChildOf(parentSpanCtx);
        }
        catch (IllegalArgumentException e) {
            spanBuilder = JaegerStartupHookProvider.tracer.buildSpan((String)endpoint);
        }
        Span rootSpan = spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.PEER_HOSTNAME.getKey(), NetUtils.getLocalAddressByDatagram()).withTag(Tags.PEER_PORT.getKey(), Server.getServerConfig().getHttpsPort()).start();
        JaegerStartupHookProvider.tracer.activateSpan(rootSpan);
        exchange.putAttachment(AttachmentConstants.ROOT_SPAN, rootSpan);
        exchange.putAttachment(AttachmentConstants.EXCHANGE_TRACER, JaegerStartupHookProvider.tracer);
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            Span span = exchange1.getAttachment(AttachmentConstants.ROOT_SPAN);
            if (span != null) {
                span.finish();
            }
            nextListener.proceed();
        });
        Handler.next(exchange, this.next);
    }

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return jaegerConfig.isEnabled();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(JaegerHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache("jaeger-tracing"), null);
    }

    @Override
    public void reload() {
        jaegerConfig = (JaegerConfig)Config.getInstance().getJsonObjectConfig("jaeger-tracing", JaegerConfig.class);
    }
}

