/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.auth;

import com.hazelcast.map.IMap;
import com.networknt.ldap.LdapUtil;
import com.networknt.oauth.auth.AuthenticatorBase;
import com.networknt.oauth.auth.DefaultAuth;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.User;
import com.networknt.oauth.security.LightGSSContextCredential;
import com.networknt.oauth.security.LightPasswordCredential;
import com.networknt.utility.HashUtil;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticator
extends AuthenticatorBase<DefaultAuth> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthenticator.class);

    @Override
    public Account authenticate(final String id, Credential credential) {
        IMap users = CacheStartupHookProvider.hz.getMap("users");
        Account account = this.getAccount(id);
        if (credential instanceof LightPasswordCredential) {
            LightPasswordCredential passwordCredential = (LightPasswordCredential)credential;
            char[] password = passwordCredential.getPassword();
            String clientAuthClass = passwordCredential.getClientAuthClass();
            String userType = passwordCredential.getUserType();
            User user = (User)users.get(account.getPrincipal().getName());
            String expectedPassword = user.getPassword();
            boolean match = false;
            try {
                match = HashUtil.validatePassword(password, expectedPassword);
                Arrays.fill(password, ' ');
            }
            catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
                logger.error("Exception:", e);
                return null;
            }
            if (!match) {
                return null;
            }
        } else if (credential instanceof LightGSSContextCredential) {
            return new Account(){
                private Set<String> roles;
                private final Principal principal;
                {
                    this.roles = LdapUtil.authorize(id);
                    this.principal = () -> id;
                }

                @Override
                public Principal getPrincipal() {
                    return this.principal;
                }

                @Override
                public Set<String> getRoles() {
                    return this.roles;
                }
            };
        }
        return account;
    }

    private Account getAccount(final String id) {
        final IMap users = CacheStartupHookProvider.hz.getMap("users");
        if (users.containsKey(id)) {
            return new Account(){
                private Set<String> roles;
                private final Principal principal;
                {
                    this.roles = DefaultAuthenticator.this.parseRoles(((User)users.get(id)).getRoles());
                    this.principal = () -> id;
                }

                @Override
                public Principal getPrincipal() {
                    return this.principal;
                }

                @Override
                public Set<String> getRoles() {
                    return this.roles;
                }
            };
        }
        return null;
    }

    public Set<String> parseRoles(String roles) {
        HashSet<String> set = Collections.EMPTY_SET;
        if (roles != null) {
            if ((roles = roles.trim()).contains(" ")) {
                set = new HashSet<String>(Arrays.asList(roles.split("\\s+")));
            } else {
                set = new HashSet<String>();
                set.add(roles);
            }
        }
        return set;
    }
}

