/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.auth;

import com.networknt.client.ClientConfig;
import com.networknt.client.ClientRequestCarrier;
import com.networknt.client.Http2Client;
import com.networknt.cluster.Cluster;
import com.networknt.config.JsonMapper;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.oauth.auth.AuthenticatorBase;
import com.networknt.oauth.auth.LightPortalAuth;
import com.networknt.oauth.security.LightPasswordCredential;
import com.networknt.server.Server;
import com.networknt.service.SingletonServiceFactory;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import io.undertow.UndertowOptions;
import io.undertow.client.ClientConnection;
import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.net.URI;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.OptionMap;

public class LightPortalAuthenticator
extends AuthenticatorBase<LightPortalAuth> {
    private static final Logger logger = LoggerFactory.getLogger(LightPortalAuthenticator.class);
    private static final String cmd = "{\"host\":\"lightapi.net\",\"service\":\"user\",\"action\":\"loginUser\",\"version\":\"0.1.0\",\"data\":{\"email\":\"%s\",\"password\":\"%s\"}}";
    private static final String queryServiceId = "com.networknt.portal.hybrid.query-1.0.0";
    private static String tag = Server.getServerConfig().getEnvironment();
    static Http2Client client = Http2Client.getInstance();
    static ClientConnection connection;
    static Cluster cluster;

    public LightPortalAuthenticator() {
        cluster = SingletonServiceFactory.getBean(Cluster.class);
        String host = cluster.serviceToUrl("https", queryServiceId, tag, null);
        if (host != null) {
            try {
                connection = client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            }
            catch (Exception e) {
                logger.error("Exception:", e);
            }
        }
    }

    @Override
    public Account authenticate(final String id, Credential credential) {
        LightPasswordCredential passwordCredential = (LightPasswordCredential)credential;
        char[] password = passwordCredential.getPassword();
        try {
            Tracer tracer;
            if (connection == null || !connection.isOpen()) {
                String host = cluster.serviceToUrl("https", queryServiceId, tag, null);
                connection = client.connect(new URI(host), Http2Client.WORKER, Http2Client.SSL, Http2Client.BUFFER_POOL, OptionMap.create(UndertowOptions.ENABLE_HTTP2, true)).get();
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference<ClientResponse> reference = new AtomicReference<ClientResponse>();
            String s2 = String.format(cmd, id, new String(password));
            String message = "/portal/query?cmd=" + URLEncoder.encode(s2, "UTF-8");
            ClientRequest request = new ClientRequest().setMethod(Methods.GET).setPath(message);
            request.getRequestHeaders().put(Headers.HOST, "localhost");
            boolean injectOpenTracing = ClientConfig.get().isInjectOpenTracing();
            if (injectOpenTracing && (tracer = passwordCredential.getExchange().getAttachment(AttachmentConstants.EXCHANGE_TRACER)) != null && tracer.activeSpan() != null) {
                Tags.SPAN_KIND.set(tracer.activeSpan(), "client");
                Tags.HTTP_METHOD.set(tracer.activeSpan(), request.getMethod().toString());
                tracer.inject(tracer.activeSpan().context(), Format.Builtin.HTTP_HEADERS, new ClientRequestCarrier(request));
            }
            connection.sendRequest(request, client.createClientCallback(reference, latch));
            latch.await();
            int statusCode = reference.get().getResponseCode();
            String body = reference.get().getAttachment(Http2Client.RESPONSE_BODY);
            if (statusCode == 200) {
                final Map<String, Object> map = JsonMapper.string2Map(body);
                Account account = new Account(){
                    private Set<String> roles;
                    private final Principal principal;
                    {
                        this.roles = LightPortalAuthenticator.this.splitRoles((String)map.get("roles"));
                        this.principal = () -> id;
                    }

                    @Override
                    public Principal getPrincipal() {
                        return this.principal;
                    }

                    @Override
                    public Set<String> getRoles() {
                        return this.roles;
                    }
                };
                return account;
            }
            final Map<String, Object> map = JsonMapper.string2Map(body);
            Account account = new Account(){
                private final Principal principal = () -> "error";

                @Override
                public Principal getPrincipal() {
                    return this.principal;
                }

                @Override
                public Set<String> getRoles() {
                    HashSet<String> roles = new HashSet<String>();
                    roles.add((String)map.get("description"));
                    return roles;
                }
            };
            return account;
        }
        catch (Exception e) {
            logger.error("Exception:", e);
            Account account = new Account(){
                private final Principal principal = () -> "error";

                @Override
                public Principal getPrincipal() {
                    return this.principal;
                }

                @Override
                public Set<String> getRoles() {
                    HashSet<String> roles = new HashSet<String>();
                    roles.add(e.getMessage());
                    return roles;
                }
            };
            return account;
        }
    }

    public Set<String> splitRoles(String roles) {
        HashSet<String> set = new HashSet<String>();
        if (roles != null) {
            String[] splited = roles.split("\\s+");
            set = new HashSet<String>(Arrays.asList(splited));
        }
        return set;
    }
}

