/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.auth;

import com.networknt.ldap.LdapUtil;
import com.networknt.oauth.auth.AuthenticatorBase;
import com.networknt.oauth.auth.MarketPlaceAuth;
import com.networknt.oauth.github.GithubUtil;
import com.networknt.oauth.security.LightPasswordCredential;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import java.security.Principal;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketPlaceAuthenticator
extends AuthenticatorBase<MarketPlaceAuth> {
    private static final Logger logger = LoggerFactory.getLogger(MarketPlaceAuthenticator.class);
    private static final String USER_TYPE_EMPLOYEE = "employee";
    private static final String USER_TYPE_PUBLIC = "public";

    @Override
    public Account authenticate(final String id, Credential credential) {
        LightPasswordCredential passwordCredential = (LightPasswordCredential)credential;
        char[] password = passwordCredential.getPassword();
        String userType = passwordCredential.getUserType();
        if (USER_TYPE_EMPLOYEE.equals(userType)) {
            boolean authenticated;
            if (logger.isDebugEnabled()) {
                logger.debug("Marketplace authenticating employee credentials");
            }
            if (authenticated = LdapUtil.authenticate(id, new String(password))) {
                Account account = null;
                try {
                    account = new Account(){
                        private Set<String> roles;
                        private final Principal principal;
                        {
                            this.roles = GithubUtil.authorize(id);
                            this.principal = () -> id;
                        }

                        @Override
                        public Principal getPrincipal() {
                            return this.principal;
                        }

                        @Override
                        public Set<String> getRoles() {
                            return this.roles;
                        }
                    };
                }
                catch (Exception e) {
                    logger.error("Exception: ", e);
                    return null;
                }
                return account;
            }
            logger.error("Failed to authenticate user '" + id + "' with LDAP");
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Marketplace authenticating public user");
        }
        if (id.equals("test") && new String(password).equals("123456")) {
            Account account = null;
            try {
                account = new Account(){
                    private Set<String> roles;
                    private final Principal principal;
                    {
                        this.roles = GithubUtil.authorize(id);
                        this.principal = () -> id;
                    }

                    @Override
                    public Principal getPrincipal() {
                        return this.principal;
                    }

                    @Override
                    public Set<String> getRoles() {
                        return this.roles;
                    }
                };
            }
            catch (Exception e) {
                logger.error("Exception: ", e);
                return null;
            }
            return account;
        }
        return null;
    }
}

