/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.provider.handler;

import com.hazelcast.map.IMap;
import com.networknt.body.BodyHandler;
import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.oauth.cache.CacheStartupHookProvider;
import com.networknt.oauth.cache.model.Provider;
import com.networknt.oauth.provider.ProviderAuditHandler;
import com.networknt.oauth.provider.handler.Oauth2ProviderPostHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Oauth2ProviderPutHandler
extends ProviderAuditHandler
implements LightHttpHandler {
    static Logger logger = LoggerFactory.getLogger(Oauth2ProviderPostHandler.class);
    static final String PROVIDER_ID_INVALID = "ERR12049";

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map body = (Map)exchange.getAttachment(BodyHandler.REQUEST_BODY);
        Provider provider = Config.getInstance().getMapper().convertValue((Object)body, Provider.class);
        String provider_id = provider.getProviderId();
        IMap<String, Provider> providers = CacheStartupHookProvider.hz.getMap("providers");
        if (providers.get(provider_id) == null) {
            this.setExchangeStatus(exchange, PROVIDER_ID_INVALID, new Object[0]);
        } else {
            providers.set(provider_id, provider);
            exchange.getResponseSender().send(Config.getInstance().getMapper().writeValueAsString(provider));
        }
        this.processAudit(exchange);
    }
}

