/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.oauth.security;

import com.networknt.oauth.auth.Authenticator;
import com.networknt.oauth.auth.DefaultAuth;
import com.networknt.oauth.security.LightGSSContextCredential;
import com.networknt.oauth.security.LightPasswordCredential;
import com.networknt.service.SingletonServiceFactory;
import io.undertow.security.idm.Account;
import io.undertow.security.idm.Credential;
import io.undertow.security.idm.IdentityManager;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightIdentityManager
implements IdentityManager {
    final Logger logger = LoggerFactory.getLogger(LightIdentityManager.class);

    @Override
    public Account verify(Account account) {
        return account;
    }

    @Override
    public Account verify(String id, Credential credential) {
        if (credential instanceof LightPasswordCredential) {
            LightPasswordCredential passwordCredential = (LightPasswordCredential)credential;
            String clientAuthClass = passwordCredential.getClientAuthClass();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("LightPasswordCredential with clientAuthClass = " + clientAuthClass);
            }
            Class clazz = DefaultAuth.class;
            if (clientAuthClass != null && clientAuthClass.trim().length() > 0) {
                try {
                    clazz = Class.forName(clientAuthClass);
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("Authenticate Class " + clientAuthClass + " not found.", e);
                    return null;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Get Authenticator implementation from service factory with clazz = " + clazz);
            }
            Authenticator authenticator = SingletonServiceFactory.getBean(Authenticator.class, clazz);
            return authenticator.authenticate(id, credential);
        }
        return null;
    }

    @Override
    public Account verify(Credential credential) {
        if (credential instanceof LightGSSContextCredential) {
            try {
                LightGSSContextCredential gssCredential = (LightGSSContextCredential)credential;
                String name = gssCredential.getGssContext().getSrcName().toString();
                String clientAuthClass = gssCredential.getClientAuthClass();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("LightGSSContextCredential with clientAuthClass = " + clientAuthClass);
                }
                Class clazz = DefaultAuth.class;
                if (clientAuthClass != null && clientAuthClass.trim().length() > 0) {
                    try {
                        clazz = Class.forName(clientAuthClass);
                    }
                    catch (ClassNotFoundException e) {
                        this.logger.error("Authenticate Class " + clientAuthClass + " not found.", e);
                        return null;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Get Authenticator implementation from service factory with clazz = " + clazz);
                }
                Authenticator authenticator = SingletonServiceFactory.getBean(Authenticator.class, clazz);
                return authenticator.authenticate(name, credential);
            }
            catch (GSSException e) {
                this.logger.error("GSSException:", e);
                return null;
            }
        }
        return null;
    }
}

