/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.networknt.client.oauth.TokenInfo;
import com.networknt.config.Config;
import com.networknt.exception.ClientException;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.handler.config.HandlerConfig;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.httpstring.HttpStringConstants;
import com.networknt.monad.Result;
import com.networknt.oas.model.Operation;
import com.networknt.oas.model.Path;
import com.networknt.oas.model.SecurityParameter;
import com.networknt.oas.model.SecurityRequirement;
import com.networknt.openapi.ApiNormalisedPath;
import com.networknt.openapi.NormalisedPath;
import com.networknt.openapi.OpenApiHandler;
import com.networknt.openapi.OpenApiHelper;
import com.networknt.openapi.OpenApiOperation;
import com.networknt.security.SecurityConfig;
import com.networknt.security.SwtVerifier;
import com.networknt.utility.ModuleRegistry;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtVerifyHandler
implements MiddlewareHandler {
    static final Logger logger = LoggerFactory.getLogger(SwtVerifyHandler.class);
    static final String OPENAPI_SECURITY_CONFIG = "openapi-security";
    static final String HANDLER_CONFIG = "handler";
    static final String STATUS_INVALID_AUTH_TOKEN = "ERR10000";
    static final String STATUS_AUTH_TOKEN_EXPIRED = "ERR10001";
    static final String STATUS_MISSING_AUTH_TOKEN = "ERR10002";
    static final String STATUS_INVALID_SCOPE_TOKEN = "ERR10003";
    static final String STATUS_SCOPE_TOKEN_EXPIRED = "ERR10004";
    static final String STATUS_AUTH_TOKEN_SCOPE_MISMATCH = "ERR10005";
    static final String STATUS_SCOPE_TOKEN_SCOPE_MISMATCH = "ERR10006";
    static final String STATUS_INVALID_REQUEST_PATH = "ERR10007";
    static final String STATUS_METHOD_NOT_ALLOWED = "ERR10008";
    static final String STATUS_CLIENT_EXCEPTION = "ERR10082";
    public static SwtVerifier swtVerifier;
    static SecurityConfig config;
    private volatile HttpHandler next;
    String basePath;

    @Override
    public HttpHandler getNext() {
        return this.next;
    }

    @Override
    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull(next);
        this.next = next;
        return this;
    }

    @Override
    public boolean isEnabled() {
        return config.isEnableVerifySwt();
    }

    @Override
    public void register() {
        ModuleRegistry.registerModule(SwtVerifyHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(OPENAPI_SECURITY_CONFIG), null);
    }

    @Override
    public void reload() {
        config.reload(OPENAPI_SECURITY_CONFIG);
        ModuleRegistry.registerModule(SwtVerifyHandler.class.getName(), Config.getInstance().getJsonMapConfigNoCache(OPENAPI_SECURITY_CONFIG), null);
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("SwtVerifyHandler.handleRequest starts.");
        }
        String reqPath = exchange.getRequestPath();
        if (config.getSkipPathPrefixes() != null) {
            if (config.getSkipPathPrefixes().stream().anyMatch(reqPath::startsWith)) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Skip request path base on skipPathPrefixes for " + reqPath);
                }
                Handler.next(exchange, this.next);
                if (logger.isDebugEnabled()) {
                    logger.debug("SwtVerifyHandler.handleRequest ends.");
                }
                return;
            }
        }
        if (this.handleSwt(exchange, reqPath, null)) {
            if (logger.isDebugEnabled()) {
                logger.debug("SwtVerifyHandler.handleRequest ends.");
            }
            Handler.next(exchange, this.next);
        }
    }

    public boolean handleSwt(HttpServerExchange exchange, String reqPath, List<String> jwkServiceIds) throws Exception {
        HashMap<String, Object> auditInfo = null;
        HeaderMap headerMap = exchange.getRequestHeaders();
        String authorization = headerMap.getFirst(Headers.AUTHORIZATION);
        if (logger.isTraceEnabled() && authorization != null && authorization.length() > 10) {
            logger.trace("Authorization header = " + authorization.substring(0, 10));
        }
        if (authorization == null) {
            this.setExchangeStatus(exchange, STATUS_MISSING_AUTH_TOKEN, new Object[0]);
            exchange.endExchange();
            if (logger.isDebugEnabled()) {
                logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
            }
            return false;
        }
        if (authorization.trim().length() < 6) {
            this.setExchangeStatus(exchange, STATUS_INVALID_AUTH_TOKEN, new Object[0]);
            exchange.endExchange();
            if (logger.isDebugEnabled()) {
                logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
            }
            return false;
        }
        String swt = SwtVerifier.getTokenFromAuthorization(authorization = this.getScopeToken(authorization, headerMap));
        if (swt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("parsed swt from authorization = " + swt.substring(0, 10));
            }
            try {
                Result<TokenInfo> tokenInfoResult = swtVerifier.verifySwt(swt, reqPath, jwkServiceIds);
                if (tokenInfoResult.isFailure()) {
                    this.setExchangeStatus(exchange, tokenInfoResult.getError());
                    if (logger.isDebugEnabled()) {
                        logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
                    }
                    return false;
                }
                TokenInfo tokenInfo = tokenInfoResult.getResult();
                auditInfo = exchange.getAttachment(AttachmentConstants.AUDIT_INFO);
                if (auditInfo == null) {
                    auditInfo = new HashMap<String, Object>();
                    exchange.putAttachment(AttachmentConstants.AUDIT_INFO, auditInfo);
                }
                String clientId = tokenInfo.getClientId();
                auditInfo.put("client_id", clientId);
                String issuer = tokenInfo.getIss();
                auditInfo.put("issuer_claims", issuer);
                if (!config.isEnableH2c() && swtVerifier.checkForH2CRequest(headerMap)) {
                    this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, new Object[0]);
                    if (logger.isDebugEnabled()) {
                        logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
                    }
                    return false;
                }
                String callerId = headerMap.getFirst(HttpStringConstants.CALLER_ID);
                if (callerId != null) {
                    auditInfo.put("caller_id", callerId);
                }
                if (config != null && config.isEnableVerifyScope()) {
                    ArrayList<String> secondaryScopes;
                    OpenApiOperation openApiOperation;
                    Operation operation;
                    if (logger.isTraceEnabled()) {
                        logger.trace("verify scope from the primary token when enableVerifyScope is true");
                    }
                    if ((operation = this.getOperation(exchange, openApiOperation = (OpenApiOperation)auditInfo.get("openapi_operation"), auditInfo)) == null) {
                        if (config.isSkipVerifyScopeWithoutSpec()) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("SwtVerifyHandler.handleRequest ends without verifying scope due to spec.");
                            }
                            Handler.next(exchange, this.next);
                        }
                        return false;
                    }
                    String scopeHeader = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
                    String scopeSwt = SwtVerifier.getTokenFromAuthorization(scopeHeader);
                    if (!this.hasValidSecondaryScopes(exchange, scopeSwt, secondaryScopes = new ArrayList<String>(), reqPath, jwkServiceIds, auditInfo)) {
                        return false;
                    }
                    if (!this.hasValidScope(exchange, scopeHeader, secondaryScopes, tokenInfo, operation)) {
                        return false;
                    }
                }
                if (config.getPassThroughClaims() != null && config.getPassThroughClaims().size() > 0) {
                    for (Map.Entry<String, String> entry : config.getPassThroughClaims().entrySet()) {
                        String key = entry.getKey();
                        String header = entry.getValue();
                        Field field = tokenInfo.getClass().getDeclaredField(key);
                        field.setAccessible(true);
                        Object value = field.get(tokenInfo);
                        if (logger.isTraceEnabled()) {
                            logger.trace("pass through header {} with value {}", (Object)header, value);
                        }
                        headerMap.put(new HttpString(header), value.toString());
                    }
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("complete SWT verification for request path = " + exchange.getRequestURI());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("SwtVerifyHandler.handleRequest ends.");
                }
                return true;
            }
            catch (ClientException e) {
                logger.error("ClientException: ", e);
                if (logger.isDebugEnabled()) {
                    logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
                }
                this.setExchangeStatus(exchange, STATUS_CLIENT_EXCEPTION, e.getMessage());
                exchange.endExchange();
                return false;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SwtVerifyHandler.handleRequest ends with an error.");
        }
        this.setExchangeStatus(exchange, STATUS_MISSING_AUTH_TOKEN, new Object[0]);
        exchange.endExchange();
        return false;
    }

    protected boolean hasValidScope(HttpServerExchange exchange, String scopeHeader, List<String> secondaryScopes, TokenInfo tokenInfo, Operation operation) {
        if (config.isEnableVerifyScope()) {
            List<String> specScopes = null;
            List<SecurityRequirement> securityRequirements = operation.getSecurityRequirements();
            if (securityRequirements != null) {
                for (SecurityRequirement requirement : securityRequirements) {
                    String oauth2Name;
                    SecurityParameter securityParameter = null;
                    Iterator<String> iterator2 = OpenApiHandler.getHelper((String)exchange.getRequestPath()).oauth2Names.iterator();
                    while (iterator2.hasNext() && (securityParameter = requirement.getRequirement(oauth2Name = iterator2.next())) == null) {
                    }
                    if (securityParameter != null) {
                        specScopes = securityParameter.getParameters();
                    }
                    if (specScopes == null) continue;
                    break;
                }
            }
            if (scopeHeader != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with scope token");
                }
                if (secondaryScopes == null || !this.matchedScopes(secondaryScopes, specScopes)) {
                    this.setExchangeStatus(exchange, STATUS_SCOPE_TOKEN_SCOPE_MISMATCH, secondaryScopes, specScopes);
                    exchange.endExchange();
                    return false;
                }
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("validate the scope with primary token");
                }
                List<String> primaryScopes = null;
                String scope = tokenInfo.getScope();
                if (scope != null) {
                    primaryScopes = Arrays.asList(scope.split(" "));
                }
                if (!this.matchedScopes(primaryScopes, specScopes)) {
                    this.setExchangeStatus(exchange, STATUS_AUTH_TOKEN_SCOPE_MISMATCH, primaryScopes, specScopes);
                    exchange.endExchange();
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean matchedScopes(List<String> tokenScopes, Collection<String> specScopes) {
        boolean matched = false;
        if (specScopes != null && specScopes.size() > 0) {
            if (tokenScopes != null && tokenScopes.size() > 0) {
                for (String scope : specScopes) {
                    if (!tokenScopes.contains(scope)) continue;
                    matched = true;
                    break;
                }
            }
        } else {
            matched = true;
        }
        return matched;
    }

    protected boolean hasValidSecondaryScopes(HttpServerExchange exchange, String scopeSwt, List<String> secondaryScopes, String reqPath, List<String> jwkServiceIds, Map<String, Object> auditInfo) {
        if (scopeSwt != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("start verifying scope token = " + scopeSwt.substring(0, 10));
            }
            try {
                Result<TokenInfo> scopeTokenInfo = swtVerifier.verifySwt(scopeSwt, reqPath, jwkServiceIds);
                if (scopeTokenInfo.isFailure()) {
                    this.setExchangeStatus(exchange, scopeTokenInfo.getError());
                    exchange.endExchange();
                    return false;
                }
                TokenInfo tokenInfo = scopeTokenInfo.getResult();
                String scope = tokenInfo.getScope();
                if (scope != null) {
                    secondaryScopes.addAll(Arrays.asList(scope.split(" ")));
                    auditInfo.put("scope_client_id", tokenInfo.getClientId());
                }
            }
            catch (Exception e) {
                logger.error("Exception", e);
                this.setExchangeStatus(exchange, STATUS_CLIENT_EXCEPTION, e.getMessage());
                exchange.endExchange();
                return false;
            }
        }
        return true;
    }

    protected Operation getOperation(HttpServerExchange exchange, OpenApiOperation openApiOperation, Map<String, Object> auditInfo) {
        Operation operation;
        if (openApiOperation == null) {
            String httpMethod;
            Optional maybeApiPath;
            ApiNormalisedPath requestPath = new ApiNormalisedPath(exchange.getRequestURI(), this.basePath);
            OpenApiHelper helper = OpenApiHandler.getHelper(exchange.getRequestPath());
            Optional<Object> optional = maybeApiPath = helper == null ? Optional.empty() : helper.findMatchingApiPath(requestPath);
            if (maybeApiPath.isEmpty()) {
                if (!config.isSkipVerifyScopeWithoutSpec()) {
                    this.setExchangeStatus(exchange, STATUS_INVALID_REQUEST_PATH, new Object[0]);
                }
                return null;
            }
            NormalisedPath swaggerPathString = (NormalisedPath)maybeApiPath.get();
            Path swaggerPath = OpenApiHandler.getHelper((String)exchange.getRequestPath()).openApi3.getPath(swaggerPathString.original());
            operation = swaggerPath.getOperation(httpMethod = exchange.getRequestMethod().toString().toLowerCase());
            if (operation == null) {
                this.setExchangeStatus(exchange, STATUS_METHOD_NOT_ALLOWED, httpMethod, swaggerPathString.normalised());
                exchange.endExchange();
                return null;
            }
            openApiOperation = new OpenApiOperation(swaggerPathString, swaggerPath, httpMethod, operation);
            auditInfo.put("openapi_operation", openApiOperation);
            auditInfo.put("endpoint", swaggerPathString.normalised() + "@" + httpMethod);
        } else {
            operation = openApiOperation.getOperation();
        }
        return operation;
    }

    protected String getScopeToken(String authorization, HeaderMap headerMap) {
        String returnToken = authorization;
        if (returnToken != null && !returnToken.substring(0, 6).equalsIgnoreCase("Bearer")) {
            returnToken = headerMap.getFirst(HttpStringConstants.SCOPE_TOKEN);
            if (logger.isTraceEnabled() && returnToken != null && returnToken.length() > 10) {
                logger.trace("The replaced authorization from X-Scope-Token header = " + returnToken.substring(0, 10));
            }
        }
        return returnToken;
    }

    public SwtVerifyHandler() {
        config = SecurityConfig.load(OPENAPI_SECURITY_CONFIG);
        swtVerifier = new SwtVerifier(config);
        HandlerConfig handlerConfig = (HandlerConfig)Config.getInstance().getJsonObjectConfig(HANDLER_CONFIG, HandlerConfig.class);
        this.basePath = handlerConfig == null ? "/" : handlerConfig.getBasePath();
    }
}

