/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi.parameter;

import com.networknt.utility.StringUtils;
import java.util.HashMap;
import java.util.Map;

public enum ValueType {
    PRIMITIVE,
    ARRAY,
    OBJECT;

    private static Map<String, ValueType> lookup;

    public static ValueType of(String typeStr) {
        ValueType type = lookup.get(StringUtils.trimToEmpty(typeStr).toUpperCase());
        return null == type ? PRIMITIVE : type;
    }

    public static boolean is(String typeStr, ValueType type) {
        return type == ValueType.of(typeStr);
    }

    static {
        lookup = new HashMap<String, ValueType>();
        for (ValueType type : ValueType.values()) {
            lookup.put(type.name(), type);
        }
    }
}

