/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.portal.registry;

import com.networknt.portal.registry.PortalRegistryService;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.registry.URLParamType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PortalRegistryUtils {
    public static boolean isSame(List<URL> urls1, List<URL> urls2) {
        if (urls1 == null && urls2 == null) {
            return true;
        }
        if (urls1 == null || urls2 == null) {
            return false;
        }
        if (urls1.size() != urls2.size()) {
            return false;
        }
        return urls1.containsAll(urls2);
    }

    public static PortalRegistryService buildService(URL url) {
        PortalRegistryService service = new PortalRegistryService();
        service.setAddress(url.getHost());
        service.setServiceId(PortalRegistryUtils.convertPortalRegistrySerivceId(url));
        service.setName(url.getPath());
        service.setProtocol(url.getProtocol());
        service.setPort(url.getPort());
        String env = url.getParameter("environment");
        if (env != null) {
            service.setTag(env);
        }
        return service;
    }

    public static URL buildUrl(String serviceId, String tag, Map<String, Object> service) {
        URLImpl url = null;
        if (url == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            if (tag != null) {
                params.put(URLParamType.environment.getName(), tag);
            }
            url = new URLImpl((String)service.get("protocol"), (String)service.get("address"), (Integer)service.get("port"), serviceId, params);
        }
        return url;
    }

    public static String getUrlClusterInfo(URL url) {
        return url.getPath();
    }

    public static String convertPortalRegistrySerivceId(URL url) {
        return url.getPath();
    }

    public static String getPathFromServiceId(String serviceId) {
        return serviceId.substring(serviceId.indexOf(":") + 1, serviceId.lastIndexOf(":"));
    }
}

