/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support;

import com.networknt.registry.NotifyListener;
import com.networknt.registry.Registry;
import com.networknt.registry.URL;
import com.networknt.registry.URLParamType;
import com.networknt.switcher.SwitcherListener;
import com.networknt.switcher.SwitcherUtil;
import com.networknt.utility.ConcurrentHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistry
implements Registry {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRegistry.class);
    private ConcurrentHashMap<URL, Map<String, List<URL>>> subscribedCategoryResponses = new ConcurrentHashMap();
    private URL registryUrl;
    private Set<URL> registeredServiceUrls = new ConcurrentHashSet<URL>();
    protected String registryClassName = this.getClass().getSimpleName();

    public AbstractRegistry(URL url) {
        this.registryUrl = url.createCopy();
        SwitcherUtil.registerSwitcherListener("RegistryHeartBeat", new SwitcherListener(){

            @Override
            public void onValueChanged(String key, Boolean value) {
                if (key != null && value != null) {
                    if (value.booleanValue()) {
                        AbstractRegistry.this.available(null);
                    } else {
                        AbstractRegistry.this.unavailable(null);
                    }
                }
            }
        });
    }

    @Override
    public void register(URL url) {
        if (url == null) {
            logger.warn("[{}] register with malformed param, url is null", (Object)this.registryClassName);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("[{}] Url ({}) will register to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        }
        this.doRegister(this.removeUnnecessaryParmas(url.createCopy()));
        this.registeredServiceUrls.add(url);
        if (SwitcherUtil.isOpen("RegistryHeartBeat")) {
            this.available(url);
        }
    }

    @Override
    public void unregister(URL url) {
        if (url == null) {
            logger.warn("[{}] unregister with malformed param, url is null", (Object)this.registryClassName);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("[{}] Url ({}) will unregister to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        }
        this.doUnregister(this.removeUnnecessaryParmas(url.createCopy()));
        this.registeredServiceUrls.remove(url);
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        if (url == null) {
            logger.warn("[{}] subscribe with malformed param, url:{}", (Object)this.registryClassName, (Object)url);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("[{}] Listener ({}) will subscribe to url ({}) in Registry [{}]", this.registryClassName, listener, url, this.registryUrl.getIdentity());
        }
        this.doSubscribe(url.createCopy(), listener);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        if (url == null) {
            logger.warn("[{}] unsubscribe with malformed param, url:{}", (Object)this.registryClassName, (Object)url);
            return;
        }
        if (logger.isInfoEnabled()) {
            logger.info("[{}] Listener ({}) will unsubscribe from url ({}) in Registry [{}]", this.registryClassName, listener, url, this.registryUrl.getIdentity());
        }
        this.doUnsubscribe(url.createCopy(), listener);
    }

    @Override
    public List<URL> discover(URL url) {
        ArrayList<URL> results;
        block5: {
            block4: {
                if (url == null) {
                    logger.warn("[{}] discover with malformed param, refUrl is null", (Object)this.registryClassName);
                    return Collections.EMPTY_LIST;
                }
                url = url.createCopy();
                results = new ArrayList<URL>();
                Map<String, List<URL>> categoryUrls = this.subscribedCategoryResponses.get(url);
                if (categoryUrls == null || categoryUrls.size() <= 0) break block4;
                for (List<URL> urls2 : categoryUrls.values()) {
                    for (URL tempUrl : urls2) {
                        results.add(tempUrl.createCopy());
                    }
                }
                break block5;
            }
            List<URL> urlsDiscovered = this.doDiscover(url);
            if (urlsDiscovered == null) break block5;
            for (URL u : urlsDiscovered) {
                results.add(u.createCopy());
            }
        }
        return results;
    }

    @Override
    public URL getUrl() {
        return this.registryUrl;
    }

    @Override
    public Collection<URL> getRegisteredServiceUrls() {
        return this.registeredServiceUrls;
    }

    @Override
    public void available(URL url) {
        if (logger.isInfoEnabled()) {
            logger.info("[{}] Url ({}) will set to available to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        }
        if (url != null) {
            this.doAvailable(this.removeUnnecessaryParmas(url.createCopy()));
        } else {
            this.doAvailable(null);
        }
    }

    @Override
    public void unavailable(URL url) {
        if (logger.isInfoEnabled()) {
            logger.info("[{}] Url ({}) will set to unavailable to Registry [{}]", this.registryClassName, url, this.registryUrl.getIdentity());
        }
        if (url != null) {
            this.doUnavailable(this.removeUnnecessaryParmas(url.createCopy()));
        } else {
            this.doUnavailable(null);
        }
    }

    List<URL> getCachedUrls(URL url) {
        Map<String, List<URL>> rsUrls = this.subscribedCategoryResponses.get(url);
        if (rsUrls == null || rsUrls.size() == 0) {
            return null;
        }
        ArrayList<URL> urls2 = new ArrayList<URL>();
        for (List<URL> us : rsUrls.values()) {
            for (URL tempUrl : us) {
                urls2.add(tempUrl.createCopy());
            }
        }
        return urls2;
    }

    protected void notify(URL refUrl, NotifyListener listener, List<URL> urls2) {
        if (listener == null || urls2 == null) {
            return;
        }
        HashMap serviceNameUrls = new HashMap();
        for (URL surl : urls2) {
            String serviceName = surl.getPath();
            List serviceUrlList = (List)serviceNameUrls.get(serviceName);
            if (serviceUrlList == null) {
                serviceNameUrls.put(serviceName, new ArrayList());
                serviceUrlList = (List)serviceNameUrls.get(serviceName);
            }
            serviceUrlList.add(surl);
        }
        Map<String, List<URL>> curls = this.subscribedCategoryResponses.get(refUrl);
        if (curls == null) {
            this.subscribedCategoryResponses.putIfAbsent(refUrl, new ConcurrentHashMap());
            curls = this.subscribedCategoryResponses.get(refUrl);
        }
        for (String serviceName : serviceNameUrls.keySet()) {
            curls.put(serviceName, (List)serviceNameUrls.get(serviceName));
        }
        for (List us : serviceNameUrls.values()) {
            listener.notify(this.getUrl(), us);
        }
    }

    private URL removeUnnecessaryParmas(URL url) {
        url.getParameters().remove(URLParamType.codec.getName());
        return url;
    }

    protected abstract void doRegister(URL var1);

    protected abstract void doUnregister(URL var1);

    protected abstract void doSubscribe(URL var1, NotifyListener var2);

    protected abstract void doUnsubscribe(URL var1, NotifyListener var2);

    protected abstract List<URL> doDiscover(URL var1);

    protected abstract void doAvailable(URL var1);

    protected abstract void doUnavailable(URL var1);
}

