/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.registry.support;

import com.networknt.config.Config;
import com.networknt.exception.FrameworkException;
import com.networknt.registry.NotifyListener;
import com.networknt.registry.URL;
import com.networknt.registry.URLImpl;
import com.networknt.registry.support.AbstractRegistry;
import com.networknt.registry.support.DirectRegistryConfig;
import com.networknt.status.Status;
import com.networknt.utility.ModuleRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectRegistry
extends AbstractRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DirectRegistry.class);
    private static final String PARSE_DIRECT_URL_ERROR = "ERR10019";
    private static final String GENERAL_TAG = "*";
    private ConcurrentHashMap<URL, Object> subscribeUrls = new ConcurrentHashMap();
    private static Map<String, List<URL>> directUrls = new HashMap<String, List<URL>>();
    private static DirectRegistryConfig config;

    public DirectRegistry(URL url) {
        super(url);
        config = DirectRegistryConfig.load();
        if (DirectRegistry.config.directUrls != null) {
            ModuleRegistry.registerModule(DirectRegistry.class.getName(), Config.getInstance().getJsonMapConfigNoCache("direct-registry"), null);
        }
        if (url.getParameters() != null && url.getParameters().size() > 0) {
            for (Map.Entry<String, String> entry : url.getParameters().entrySet()) {
                String tag = null;
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace("entry key = " + entry.getKey() + " entry value = " + entry.getValue());
                    }
                    if (entry.getValue().contains(",")) {
                        String[] directUrlArray;
                        for (String directUrl : directUrlArray = entry.getValue().split(",")) {
                            String s2 = this.buildUrl(directUrl, entry.getKey());
                            URL u = URLImpl.valueOf(s2);
                            tag = u.getParameter("environment");
                            Object key = tag == null ? entry.getKey() : entry.getKey() + "|" + tag;
                            List<URL> urls2 = directUrls.get(key);
                            if (urls2 != null) {
                                urls2.add(u);
                            } else {
                                urls2 = new ArrayList<URL>();
                                urls2.add(u);
                            }
                            directUrls.put((String)key, urls2);
                        }
                        continue;
                    }
                    ArrayList<URL> urls3 = new ArrayList<URL>();
                    String s3 = this.buildUrl(entry.getValue(), entry.getKey());
                    URL u = URLImpl.valueOf(s3);
                    tag = u.getParameter("environment");
                    String key = tag == null ? entry.getKey() : entry.getKey() + "|" + tag;
                    urls3.add(u);
                    directUrls.put(key, urls3);
                }
                catch (Exception e) {
                    logger.error("Exception: ", e);
                    throw new FrameworkException(new Status(PARSE_DIRECT_URL_ERROR, url.toString()));
                }
            }
        } else {
            directUrls = config.getDirectUrls();
        }
    }

    private String buildUrl(String url, String key) {
        if (url.contains("?")) {
            String u = url.substring(0, url.indexOf("?"));
            String p = url.substring(url.indexOf("?"));
            return u.trim() + "/" + key + p;
        }
        return url.trim() + "/" + key;
    }

    @Override
    protected void doRegister(URL url) {
    }

    @Override
    protected void doUnregister(URL url) {
    }

    @Override
    protected void doSubscribe(URL url, NotifyListener listener) {
        this.subscribeUrls.putIfAbsent(url, 1);
        if (listener != null) {
            listener.notify(this.getUrl(), this.doDiscover(url));
        }
    }

    @Override
    protected void doUnsubscribe(URL url, NotifyListener listener) {
        this.subscribeUrls.remove(url);
        if (listener != null) {
            listener.notify(this.getUrl(), this.doDiscover(url));
        }
    }

    @Override
    protected List<URL> doDiscover(URL subscribeUrl) {
        return this.createSubscribeUrl(subscribeUrl);
    }

    private List<URL> createSubscribeUrl(URL subscribeUrl) {
        String serviceId = subscribeUrl.getPath();
        String tag = subscribeUrl.getParameter("environment");
        String key = tag == null ? serviceId : serviceId + "|" + tag;
        return directUrls.get(key);
    }

    @Override
    protected void doAvailable(URL url) {
    }

    @Override
    protected void doUnavailable(URL url) {
    }

    public static void reload() {
        config.reload();
        directUrls = config.getDirectUrls();
        if (directUrls != null) {
            ModuleRegistry.registerModule(DirectRegistry.class.getName(), Config.getInstance().getJsonMapConfigNoCache("direct-registry"), null);
        }
    }
}

