/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.client.ClientConfig;
import com.networknt.client.oauth.OauthHelper;
import com.networknt.client.oauth.TokenInfo;
import com.networknt.client.oauth.TokenIntrospectionRequest;
import com.networknt.config.ConfigException;
import com.networknt.config.JsonMapper;
import com.networknt.monad.Failure;
import com.networknt.monad.Result;
import com.networknt.monad.Success;
import com.networknt.security.SecurityConfig;
import com.networknt.security.TokenVerifier;
import com.networknt.status.Status;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtVerifier
extends TokenVerifier {
    static final Logger logger = LoggerFactory.getLogger(SwtVerifier.class);
    public static final String OAUTH_INTROSPECTION_ERROR = "ERR10079";
    public static final String TOKEN_INFO_ERROR = "ERR10080";
    public static final String INTROSPECTED_TOKEN_EXPIRED = "ERR10081";
    static SecurityConfig config;

    public SwtVerifier(SecurityConfig config) {
        SwtVerifier.config = config;
        if (logger.isInfoEnabled()) {
            logger.info("SwtVerifier is constructed.");
        }
    }

    public Result<TokenInfo> verifySwt(String swt, String requestPath, List<String> swtServiceIds) {
        return this.getTokenInfoForToken(swt, swtServiceIds != null ? swtServiceIds : requestPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result<TokenInfo> getTokenInfoForToken(String swt, Object requestPathOrSwtServiceIds) {
        String serviceId;
        Map<String, Object> config;
        if (logger.isTraceEnabled()) {
            logger.trace("swt = " + swt + requestPathOrSwtServiceIds instanceof String ? " requestPath = " + requestPathOrSwtServiceIds : " swtServiceIds = " + requestPathOrSwtServiceIds);
        }
        ClientConfig clientConfig = ClientConfig.get();
        Result<TokenInfo> result = null;
        if (requestPathOrSwtServiceIds == null) return this.inspectToken(swt, null);
        if (!clientConfig.isMultipleAuthServers()) return this.inspectToken(swt, null);
        if (requestPathOrSwtServiceIds instanceof String) {
            String requestPath = (String)requestPathOrSwtServiceIds;
            Map<String, String> pathPrefixServices = clientConfig.getPathPrefixServices();
            if (pathPrefixServices == null) throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            if (pathPrefixServices.size() == 0) {
                throw new ConfigException("pathPrefixServices property is missing or has an empty value in client.yml");
            }
            String serviceId2 = null;
            for (Map.Entry<String, String> entry : pathPrefixServices.entrySet()) {
                if (!requestPath.startsWith(entry.getKey())) continue;
                serviceId2 = entry.getValue();
            }
            if (serviceId2 == null) {
                throw new ConfigException("serviceId cannot be identified in client.yml with the requestPath = " + requestPath);
            }
            Map<String, Object> config2 = this.getJwkConfig(clientConfig, serviceId2);
            return this.inspectToken(swt, config2);
        }
        if (!(requestPathOrSwtServiceIds instanceof List)) throw new ConfigException("requestPathOrSwtServiceIds must be a string or a list of strings");
        List swtServiceIds = (List)requestPathOrSwtServiceIds;
        Iterator iterator2 = swtServiceIds.iterator();
        do {
            if (!iterator2.hasNext()) return result;
        } while (!(result = this.inspectToken(swt, config = this.getJwkConfig(clientConfig, serviceId = (String)iterator2.next()))).isSuccess());
        return result;
    }

    private Result<TokenInfo> inspectToken(String swt, Map<String, Object> config) {
        if (logger.isTraceEnabled() && config != null) {
            logger.trace("OAuth token info introspection config = " + JsonMapper.toJson(config));
        }
        TokenIntrospectionRequest introspectionRequest = new TokenIntrospectionRequest(swt, config);
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Getting token info from {}", (Object)introspectionRequest.getServerUrl());
            }
            Result<String> result = OauthHelper.getIntrospection(swt, introspectionRequest);
            if (logger.isTraceEnabled()) {
                logger.trace("Got token info response body {} from {}", (Object)result.getResult(), (Object)introspectionRequest.getServerUrl());
            }
            if (result.isFailure()) {
                return Failure.of(result.getError());
            }
            TokenInfo tokenInfo = JsonMapper.fromJson(result.getResult(), TokenInfo.class);
            if (tokenInfo.getError() != null) {
                return Failure.of(new Status(TOKEN_INFO_ERROR, tokenInfo.getError(), tokenInfo.getErrorDescription()));
            }
            if (!tokenInfo.isActive()) {
                return Failure.of(new Status(INTROSPECTED_TOKEN_EXPIRED, swt));
            }
            return Success.of(tokenInfo);
        }
        catch (Exception e) {
            logger.error("Failed to get token info - {} - {}", new Status(OAUTH_INTROSPECTION_ERROR, introspectionRequest.getServerUrl(), swt), e.getMessage(), e);
            return Failure.of(new Status(OAUTH_INTROSPECTION_ERROR, introspectionRequest.getServerUrl(), swt));
        }
    }
}

