/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.security;

import com.networknt.client.ClientConfig;
import com.networknt.config.ConfigException;
import io.undertow.util.HeaderMap;
import io.undertow.util.Headers;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenVerifier {
    static final Logger logger = LoggerFactory.getLogger(TokenVerifier.class);

    protected Map<String, Object> getJwkConfig(ClientConfig clientConfig, String serviceId) {
        Map<String, Object> tokenConfig;
        Map keyConfig;
        Map serviceIdAuthServers;
        if (logger.isTraceEnabled()) {
            logger.trace("serviceId = " + serviceId);
        }
        if ((serviceIdAuthServers = (Map)(keyConfig = (Map)(tokenConfig = clientConfig.getTokenConfig()).get("key")).get("serviceIdAuthServers")) == null) {
            throw new ConfigException("serviceIdAuthServers property is missing in the token key configuration in client.yml");
        }
        return (Map)serviceIdAuthServers.get(serviceId);
    }

    public static String getTokenFromAuthorization(String authorization) {
        String[] parts;
        String token = null;
        if (authorization != null && (parts = authorization.split(" ")).length == 2) {
            String scheme = parts[0];
            String credentials = parts[1];
            Pattern pattern = Pattern.compile("^Bearer$", 2);
            if (pattern.matcher(scheme).matches()) {
                token = credentials;
            }
        }
        return token;
    }

    public boolean checkForH2CRequest(HeaderMap headerMap) {
        return headerMap.getFirst(Headers.UPGRADE) != null && headerMap.getFirst(Headers.CONNECTION) != null && headerMap.getFirst(Headers.CONNECTION).equalsIgnoreCase("upgrade");
    }
}

