/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import com.networknt.server.IConfigLoader;
import com.networknt.server.Server;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class DefaultConfigLoader
implements IConfigLoader {
    static final Logger logger = LoggerFactory.getLogger(DefaultConfigLoader.class);
    public static Map<String, Object> startupConfig = Config.getInstance().getJsonMapConfig("startup");
    private static final String CENTRALIZED_MANAGEMENT = "values";
    public static final String LIGHT_ENV = "light-env";
    public static final String VERIFY_HOSTNAME_FALSE = "false";
    public static final String DEFAULT_ENV = "dev";
    public static final String DEFAULT_TARGET_CONFIGS_DIRECTORY = "src/main/resources/config";
    public static final String CONFIG_SERVER_URI = "light-config-server-uri";
    public static final String CONFIG_SERVER_CONFIGS_CONTEXT_ROOT = "/config-server/configs";
    public static final String CONFIG_SERVER_CERTS_CONTEXT_ROOT = "/config-server/certs";
    public static final String CONFIG_SERVER_FILES_CONTEXT_ROOT = "/config-server/files";
    public static final String AUTHORIZATION = "config_server_authorization";
    public static final String CLIENT_TRUSTSTORE_PASS = "config_server_client_truststore_password";
    public static final String CLIENT_TRUSTSTORE_LOC = "config_server_client_truststore_location";
    public static final String VERIFY_HOST_NAME = "config_server_client_verify_host_name";
    public static final String PRODUCT_ID = "productId";
    public static final String PRODUCT_VERSION = "productVersion";
    public static final String API_ID = "apiId";
    public static final String API_VERSION = "apiVersion";
    public static final String ENV_TAG = "envTag";
    public static String lightEnv = null;
    public static String configServerUri = null;
    public static String targetConfigsDirectory = null;
    static final ObjectMapper mapper = new ObjectMapper();
    private HttpClient configClient;

    private HttpClient createHttpClient() {
        String verifyHostname = DefaultConfigLoader.getPropertyOrEnv(VERIFY_HOST_NAME);
        if (VERIFY_HOSTNAME_FALSE.equals(verifyHostname)) {
            Properties props = System.getProperties();
            props.setProperty("jdk.internal.httpclient.disableHostnameVerification", Boolean.TRUE.toString());
        }
        HttpClient.Builder clientBuilder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofMillis(1000L)).version(HttpClient.Version.HTTP_2).sslContext(DefaultConfigLoader.createBootstrapContext());
        return clientBuilder.build();
    }

    @Override
    public void init() {
        lightEnv = DefaultConfigLoader.getPropertyOrEnv(LIGHT_ENV);
        if (lightEnv == null) {
            logger.warn("Warning! {} is not provided; defaulting to {}", (Object)LIGHT_ENV, (Object)DEFAULT_ENV);
            lightEnv = DEFAULT_ENV;
        }
        if ((targetConfigsDirectory = DefaultConfigLoader.getPropertyOrEnv("light-4j-config-dir")) == null) {
            logger.warn("Warning! {} is not provided; defaulting to {}", (Object)"light-4j-config-dir", (Object)DEFAULT_TARGET_CONFIGS_DIRECTORY);
            targetConfigsDirectory = DEFAULT_TARGET_CONFIGS_DIRECTORY;
        }
        if ((configServerUri = DefaultConfigLoader.getPropertyOrEnv(CONFIG_SERVER_URI)) != null) {
            logger.info("Loading configs from config server");
            if (logger.isDebugEnabled()) {
                logger.debug("light-env:" + lightEnv);
                logger.debug("targetConfigsDirectory:" + targetConfigsDirectory);
                logger.debug("configServerUri:" + configServerUri);
            }
            this.configClient = this.createHttpClient();
            try {
                String queryParameters = DefaultConfigLoader.getConfigServerQueryParameters();
                this.loadConfigs(queryParameters);
                this.loadFiles(queryParameters, CONFIG_SERVER_CERTS_CONTEXT_ROOT);
                this.loadFiles(queryParameters, CONFIG_SERVER_FILES_CONTEXT_ROOT);
            }
            catch (Exception e) {
                logger.error("Failed to connect to config server", e);
            }
            try {
                String filename = System.getProperty("logback.configurationFile");
                if (filename != null && Files.exists(Paths.get(filename, new String[0]), new LinkOption[0])) {
                    logger.info("Resetting logback configuration from {}", (Object)filename);
                    LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
                    lc.reset();
                    JoranConfigurator config = new JoranConfigurator();
                    config.setContext(lc);
                    config.doConfigure(filename);
                }
            }
            catch (JoranException e) {
                logger.error("Logback configuration failed", e);
            }
        } else {
            logger.warn("Warning! {} is not provided; using local configs", (Object)CONFIG_SERVER_URI);
        }
    }

    @Override
    public void reloadConfig() {
        configServerUri = DefaultConfigLoader.getPropertyOrEnv(CONFIG_SERVER_URI);
        if (configServerUri != null) {
            logger.info("Loading configs from config server");
            if (logger.isDebugEnabled()) {
                logger.debug("light-env:" + lightEnv);
                logger.debug("targetConfigsDirectory:" + targetConfigsDirectory);
                logger.debug("configServerUri:" + configServerUri);
            }
            this.configClient = this.createHttpClient();
            try {
                String queryParameters = DefaultConfigLoader.getConfigServerQueryParameters();
                this.loadConfigs(queryParameters);
            }
            catch (Exception e) {
                logger.error("Failed to connect to config server", e);
            }
        } else {
            logger.warn("Warning! {} is not provided; using local configs", (Object)CONFIG_SERVER_URI);
        }
    }

    private synchronized void loadConfigs(String queryParameters) {
        String configServerConfigsPath = CONFIG_SERVER_CONFIGS_CONTEXT_ROOT + queryParameters;
        Map serviceConfigs = this.getServiceConfigs(configServerConfigsPath);
        if (logger.isDebugEnabled()) {
            logger.debug("serviceConfigs received from Config Server: ", (Object)JsonMapper.toJson(serviceConfigs));
        }
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        serviceConfigs = (Map)Config.getInstance().getYaml().load(new Yaml(options).dump(serviceConfigs));
        Config.getInstance().clear();
        Config.getInstance().putInConfigCache(CENTRALIZED_MANAGEMENT, serviceConfigs);
    }

    private void loadFiles(String configPath, String contextRoot) {
        String configServerFilesPath = contextRoot + configPath;
        Map<String, Object> serviceFiles = this.getServiceConfigs(configServerFilesPath);
        if (logger.isDebugEnabled()) {
            logger.debug("loadFiles:", (Object)JsonMapper.toJson(serviceFiles));
        }
        try {
            Path filePath = Paths.get(targetConfigsDirectory, new String[0]);
            if (!Files.exists(filePath, new LinkOption[0])) {
                Files.createDirectories(filePath, new FileAttribute[0]);
                logger.info("target configs directory created :", (Object)targetConfigsDirectory);
            }
            Base64.Decoder decoder = Base64.getMimeDecoder();
            for (String fileName : serviceFiles.keySet()) {
                filePath = Paths.get(targetConfigsDirectory + "/" + fileName, new String[0]);
                byte[] ba = decoder.decode(serviceFiles.get(fileName).toString().getBytes());
                Files.write(filePath, ba, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            logger.error("Exception while creating {} dir or creating files there:{}", (Object)targetConfigsDirectory, (Object)e);
        }
    }

    public String getConfigServerHealth(String host, String path) {
        String result = null;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(host + path)).build();
        try {
            HttpResponse<String> response = this.configClient.send(request, HttpResponse.BodyHandlers.ofString());
            result = response.body();
        }
        catch (Exception e) {
            logger.error("Exception while calling config server:", e);
        }
        return result;
    }

    private Map<String, Object> getServiceConfigs(String configServerPath) {
        String authorization = DefaultConfigLoader.getPropertyOrEnv(AUTHORIZATION);
        if (authorization == null) {
            authorization = "";
        }
        Map<String, Object> configs = new HashMap<String, Object>();
        if (logger.isDebugEnabled()) {
            logger.debug("Calling Config Server endpoint:host{}:path{}", (Object)configServerUri, (Object)configServerPath);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(configServerUri.trim() + configServerPath.trim())).header("Authorization", authorization).build();
        try {
            HttpResponse<String> response = this.configClient.send(request, HttpResponse.BodyHandlers.ofString());
            int statusCode = response.statusCode();
            String body = response.body();
            if (statusCode >= 300) {
                logger.error("Failed to load configs from config server" + statusCode + ":" + body);
                throw new Exception("Failed to load configs from config server: " + statusCode);
            }
            configs = mapper.readValue(body, new TypeReference<Map<String, Object>>(){});
            this.processNestedMap(configs);
        }
        catch (Exception e) {
            logger.error("Exception while calling config server:", e);
        }
        return configs;
    }

    private void processNestedMap(Map<String, Object> map) {
        for (String key : map.keySet()) {
            String value = (String)map.get(key);
            if (!value.contains("\n")) continue;
            Object valueObject = this.processNestedString(value);
            map.put(key, valueObject);
        }
    }

    private Object processNestedString(String str) {
        String[] strArray = str.split("\n");
        int level = this.getLeadingSpaces(strArray[1]);
        boolean isList = strArray[1].stripLeading().charAt(0) == '-';
        boolean isSameLevel = true;
        StringBuilder temp = new StringBuilder();
        if (isList) {
            ArrayList<Object> resList = new ArrayList<Object>();
            for (int i = 1; i < strArray.length; ++i) {
                if (this.getLeadingSpaces(strArray[i]) == level) {
                    if (!isSameLevel) {
                        resList.add(this.processNestedString(temp.toString()));
                        temp = new StringBuilder();
                        isSameLevel = true;
                    }
                    if (strArray[i].length() == 3) {
                        isSameLevel = false;
                        continue;
                    }
                    if (strArray[i].contains(":")) {
                        isSameLevel = false;
                        temp.append("\n").append(strArray[i].replaceFirst("-", " "));
                        continue;
                    }
                    resList.add(strArray[i].substring(level + 2));
                    continue;
                }
                isSameLevel = false;
                temp.append("\n").append(strArray[i]);
            }
            if (temp.length() != 0) {
                resList.add(this.processNestedString(temp.toString()));
            }
            return resList;
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        String lastKey = "";
        for (int i = 1; i < strArray.length; ++i) {
            if (this.getLeadingSpaces(strArray[i]) == level) {
                String[] keyValue = strArray[i].split(":");
                String key = keyValue[0].stripLeading();
                if (!isSameLevel) {
                    resMap.put(lastKey, this.processNestedString(temp.toString()));
                    temp = new StringBuilder();
                    isSameLevel = true;
                }
                if (keyValue.length == 2) {
                    resMap.put(key, keyValue[1].stripLeading());
                    continue;
                }
                lastKey = key;
                continue;
            }
            isSameLevel = false;
            temp.append("\n").append(strArray[i]);
        }
        if (temp.length() != 0) {
            resMap.put(lastKey, this.processNestedString(temp.toString()));
        }
        return resMap;
    }

    private int getLeadingSpaces(String s2) {
        int res = 0;
        for (char c : s2.toCharArray()) {
            if (c != ' ') break;
            ++res;
        }
        return res;
    }

    private static String getConfigServerQueryParameters() {
        StringBuilder qs = new StringBuilder();
        qs.append("?").append(PRODUCT_ID).append("=").append(startupConfig.get(PRODUCT_ID));
        if (startupConfig.get(PRODUCT_VERSION) != null) {
            qs.append("&").append(PRODUCT_VERSION).append("=").append(startupConfig.get(PRODUCT_VERSION));
        }
        if (startupConfig.get(API_ID) != null) {
            qs.append("&").append(API_ID).append("=").append(startupConfig.get(API_ID));
        }
        if (startupConfig.get(API_VERSION) != null) {
            qs.append("&").append(API_VERSION).append("=").append(startupConfig.get(API_VERSION));
        }
        if (lightEnv != null) {
            qs.append("&").append(ENV_TAG).append("=").append(lightEnv);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("configParameters: {}", (Object)qs);
        }
        return qs.toString();
    }

    private static KeyStore loadBootstrapTrustStore() {
        KeyStore keyStore;
        String truststorePassword = DefaultConfigLoader.getPropertyOrEnv(CLIENT_TRUSTSTORE_PASS);
        String truststoreLocation = DefaultConfigLoader.getPropertyOrEnv(CLIENT_TRUSTSTORE_LOC);
        if (truststoreLocation == null) {
            truststoreLocation = Server.getServerConfig().getBootstrapStoreName();
        }
        if (truststorePassword == null) {
            truststorePassword = Server.getServerConfig().getBootstrapStorePass();
        }
        FileInputStream stream = new FileInputStream(truststoreLocation);
        try {
            if (stream == null) {
                String message = "Unable to load truststore '" + truststoreLocation + "', please provide the correct truststore to enable TLS connection.";
                if (logger.isErrorEnabled()) {
                    logger.error(message);
                }
                throw new RuntimeException(message);
            }
            KeyStore loadedKeystore = KeyStore.getInstance("JKS");
            loadedKeystore.load(stream, truststorePassword != null ? truststorePassword.toCharArray() : null);
            keyStore = loadedKeystore;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Unable to load truststore: " + truststoreLocation, e);
                throw new RuntimeException("Unable to load truststore: " + truststoreLocation, e);
            }
        }
        ((InputStream)stream).close();
        return keyStore;
    }

    private static TrustManager[] buildTrustManagers(KeyStore trustStore) {
        TrustManager[] trustManagers = null;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            logger.error("Unable to initialise TrustManager[]", e);
            throw new RuntimeException("Unable to initialise TrustManager[]", e);
        }
        return trustManagers;
    }

    private static SSLContext createBootstrapContext() throws RuntimeException {
        SSLContext sslContext = null;
        try {
            TrustManager[] trustManagers = DefaultConfigLoader.buildTrustManagers(DefaultConfigLoader.loadBootstrapTrustStore());
            sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, trustManagers, null);
        }
        catch (Exception e) {
            logger.error("Unable to create SSLContext", e);
            throw new RuntimeException("Unable to create SSLContext", e);
        }
        return sslContext;
    }

    private static String getPropertyOrEnv(String key) {
        String s2 = System.getProperty(key);
        if (s2 == null) {
            s2 = System.getenv(key);
        }
        if (s2 == null) {
            s2 = System.getenv(key.toUpperCase());
        }
        if (s2 == null) {
            s2 = System.getenv(key.toUpperCase().replaceAll("-", "_"));
        }
        return s2;
    }
}

