/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.status;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.config.Config;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.status.HttpStatus;
import com.networknt.status.StatusSerializer;
import com.networknt.utility.ModuleRegistry;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Status {
    private static final Logger logger = LoggerFactory.getLogger(Status.class);
    public static final String CONFIG_NAME = "status";
    public static final String defaultSeverity = "ERROR";
    public static final String SHOW_METADATA = "showMetadata";
    public static final String SHOW_DESCRIPTION = "showDescription";
    public static final String SHOW_MESSAGE = "showMessage";
    private static StatusSerializer statusSerializer;
    private int statusCode;
    private String code;
    private String severity;
    private String message;
    private String description;
    private Map<String, Object> metadata;
    private static Map<String, Object> config;

    public Status() {
    }

    public Status(String code, Object ... args2) {
        this.code = code;
        Map map = (Map)config.get(code);
        if (map != null) {
            this.statusCode = (Integer)map.get("statusCode");
            this.message = (String)map.get("message");
            this.description = (String)map.get("description");
            try {
                this.description = String.format(this.description, args2);
            }
            catch (IllegalFormatException illegalFormatException) {
                // empty catch block
            }
            this.severity = (String)map.get("severity");
            if (this.severity == null) {
                this.severity = defaultSeverity;
            }
        }
    }

    public Status(String code, Map<String, Object> metadata, Object ... args2) {
        this.code = code;
        Map map = (Map)config.get(code);
        if (map != null) {
            this.statusCode = (Integer)map.get("statusCode");
            this.message = (String)map.get("message");
            this.description = (String)map.get("description");
            this.metadata = metadata;
            try {
                this.description = String.format(this.description, args2);
            }
            catch (IllegalFormatException illegalFormatException) {
                // empty catch block
            }
            this.severity = (String)map.get("severity");
            if (this.severity == null) {
                this.severity = defaultSeverity;
            }
        }
    }

    public Status(int statusCode, String code, String message, String description) {
        this.statusCode = statusCode;
        this.code = code;
        this.severity = defaultSeverity;
        this.message = message;
        this.description = description;
    }

    public Status(HttpStatus httpStatus, String message, String description) {
        this.statusCode = httpStatus.value();
        this.code = httpStatus.getReasonPhrase();
        this.severity = defaultSeverity;
        this.message = message;
        this.description = description;
    }

    public Status(int statusCode, String code, String message, String description, String severity) {
        this.statusCode = statusCode;
        this.code = code;
        this.severity = severity;
        this.message = message;
        this.description = description;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public static boolean shouldShowMetadata() {
        return config.get(SHOW_METADATA) == null ? false : (Boolean)config.get(SHOW_METADATA);
    }

    public static boolean shouldShowMessage() {
        return config.get(SHOW_MESSAGE) == null ? true : (Boolean)config.get(SHOW_MESSAGE);
    }

    public static boolean shouldShowDescription() {
        return config.get(SHOW_DESCRIPTION) == null ? true : (Boolean)config.get(SHOW_DESCRIPTION);
    }

    public void putMetadata(String key, Object value) {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        this.metadata.put(key, value);
    }

    public String toString() {
        if (statusSerializer != null) {
            return statusSerializer.serializeStatus(this);
        }
        return this.toStringConditionally(true, true, true);
    }

    public String toStringConditionally() {
        return this.toStringConditionally(Status.shouldShowMessage(), Status.shouldShowDescription(), Status.shouldShowMetadata());
    }

    private String toStringConditionally(boolean showMessage, boolean showDescription, boolean showMetadata) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append("\"statusCode\":" + this.getStatusCode()).append(",\"code\":\"" + this.getCode());
        if (showMessage) {
            sb.append("\",\"message\":\"" + this.getMessage());
        }
        if (showDescription) {
            sb.append("\",\"description\":\"" + this.getDescription());
        }
        if (showMetadata && this.getMetadata() != null) {
            try {
                sb.append("\",\"metadata\":" + Config.getInstance().getMapper().writeValueAsString(this.getMetadata()));
            }
            catch (JsonProcessingException e) {
                logger.error("cannot parse metadata for status:" + this.getStatusCode(), e);
            }
            sb.append(",\"severity\":\"" + this.getSeverity());
        } else {
            sb.append("\",\"severity\":\"" + this.getSeverity());
        }
        sb.append("\"}");
        return sb.toString();
    }

    public static void reload() {
        config = Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME);
        ModuleRegistry.registerModule(Status.class.getName(), config, null);
    }

    public static Map<String, Object> getConfig() {
        return config;
    }

    static {
        config = Config.getInstance().getJsonMapConfig(CONFIG_NAME);
        ModuleRegistry.registerModule(Status.class.getName(), config, null);
        try {
            statusSerializer = SingletonServiceFactory.getBean(StatusSerializer.class);
        }
        catch (ExceptionInInitializerError e) {
            statusSerializer = null;
        }
    }
}

