/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.influxdb.data;

import io.dropwizard.metrics.influxdb.data.InfluxDbPoint;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

public class InfluxDbWriteObject {
    private String precision;
    private Set<InfluxDbPoint> points;
    private Map<String, String> tags = Collections.emptyMap();

    public InfluxDbWriteObject(TimeUnit timeUnit) {
        this.points = new HashSet<InfluxDbPoint>();
        this.precision = InfluxDbWriteObject.toTimePrecision(timeUnit);
    }

    private static String toTimePrecision(TimeUnit t2) {
        switch (t2) {
            case HOURS: {
                return "h";
            }
            case MINUTES: {
                return "m";
            }
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "u";
            }
            case NANOSECONDS: {
                return "n";
            }
        }
        throw new IllegalArgumentException("time precision should be HOURS OR MINUTES OR SECONDS or MILLISECONDS or MICROSECONDS OR NANOSECONDS");
    }

    public String getPrecision() {
        return this.precision;
    }

    public void setPrecision(String precision) {
        this.precision = precision;
    }

    public Set<InfluxDbPoint> getPoints() {
        return this.points;
    }

    public void setPoints(Set<InfluxDbPoint> points) {
        this.points = points;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = Collections.unmodifiableMap(tags);
    }

    public String getBody() {
        StringJoiner joiner = new StringJoiner("\n");
        for (InfluxDbPoint point : this.points) {
            joiner.add(((Object)point).toString());
        }
        return joiner.toString();
    }
}

