/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.propagation;

import io.jaegertracing.internal.JaegerObjectFactory;
import io.jaegertracing.internal.JaegerSpanContext;
import io.jaegertracing.internal.propagation.HexCodec;
import io.jaegertracing.spi.Codec;
import io.opentracing.propagation.TextMap;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceContextCodec
implements Codec<TextMap> {
    private static final Logger log = LoggerFactory.getLogger(TraceContextCodec.class);
    static final String TRACE_PARENT = "traceparent";
    static final String TRACE_STATE = "tracestate";
    private static final String VERSION = "00";
    private static final int VERSION_SIZE = 2;
    private static final char TRACEPARENT_DELIMITER = '-';
    private static final int TRACEPARENT_DELIMITER_SIZE = 1;
    private static final int TRACE_ID_HEX_SIZE = 32;
    private static final int SPAN_ID_HEX_SIZE = 16;
    private static final int TRACE_FLAGS_HEX_SIZE = 2;
    private static final int TRACE_ID_OFFSET = 3;
    private static final int SPAN_ID_OFFSET = 36;
    private static final int TRACE_OPTION_OFFSET = 53;
    private static final int TRACEPARENT_HEADER_SIZE = 55;
    private static final byte SAMPLED_FLAG = 1;
    private final JaegerObjectFactory objectFactory;

    private TraceContextCodec(Builder builder) {
        this.objectFactory = builder.objectFactory;
    }

    private JaegerSpanContext extractContextFromTraceParent(String traceparent, String tracestate, String debugId) {
        boolean isValid;
        boolean bl = isValid = traceparent != null && traceparent.charAt(52) == '-' && (traceparent.length() == 55 || traceparent.length() > 55 && traceparent.charAt(55) == '-') && traceparent.charAt(35) == '-' && traceparent.charAt(52) == '-';
        if (!isValid) {
            log.warn("Unparseable traceparent header. Returning null span context.");
            return null;
        }
        Long traceIdHigh = HexCodec.hexToUnsignedLong(traceparent, 3, 19);
        Long traceIdLow = HexCodec.hexToUnsignedLong(traceparent, 19, 35);
        Long spanId = HexCodec.hexToUnsignedLong(traceparent, 36, 52);
        boolean sampled = false;
        long traceContextFlags = HexCodec.hexToUnsignedLong(traceparent, 53, 55);
        if ((traceContextFlags & 1L) == 1L) {
            sampled = true;
        }
        if (traceIdLow == null || traceIdLow == 0L || spanId == null || spanId == 0L) {
            log.warn("Unparseable traceparent header. Returning null span context.");
            return null;
        }
        JaegerSpanContext spanContext = this.objectFactory.createSpanContext(traceIdHigh, traceIdLow, spanId, 0L, sampled ? (byte)1 : 0, Collections.emptyMap(), debugId);
        return spanContext.withTraceState(tracestate);
    }

    @Override
    public JaegerSpanContext extract(TextMap carrier) {
        String traceParent = null;
        String traceState = null;
        String debugId = null;
        for (Map.Entry<String, String> entry : carrier) {
            if (TRACE_PARENT.equalsIgnoreCase(entry.getKey())) {
                traceParent = entry.getValue();
            }
            if (TRACE_STATE.equalsIgnoreCase(entry.getKey())) {
                traceState = entry.getValue();
            }
            if (!"jaeger-debug-id".equalsIgnoreCase(entry.getKey())) continue;
            debugId = entry.getValue();
        }
        if (traceParent == null) {
            if (debugId != null) {
                return this.objectFactory.createSpanContext(0L, 0L, 0L, 0L, (byte)0, null, debugId);
            }
            return null;
        }
        return this.extractContextFromTraceParent(traceParent, traceState, debugId);
    }

    @Override
    public void inject(JaegerSpanContext spanContext, TextMap carrier) {
        char[] chars = new char[55];
        chars[0] = VERSION.charAt(0);
        chars[1] = VERSION.charAt(1);
        chars[2] = 45;
        HexCodec.writeHexLong(chars, 3, spanContext.getTraceIdHigh());
        HexCodec.writeHexLong(chars, 19, spanContext.getTraceIdLow());
        chars[35] = 45;
        HexCodec.writeHexLong(chars, 36, spanContext.getSpanId());
        chars[52] = 45;
        chars[53] = 48;
        chars[54] = spanContext.isSampled() ? 49 : 48;
        carrier.put(TRACE_PARENT, new String(chars));
        if (spanContext.getTraceState() != null && !spanContext.getTraceState().isEmpty()) {
            carrier.put(TRACE_STATE, spanContext.getTraceState());
        }
    }

    public static class Builder {
        private JaegerObjectFactory objectFactory = new JaegerObjectFactory();

        public Builder withObjectFactory(JaegerObjectFactory objectFactory) {
            this.objectFactory = objectFactory;
            return this;
        }

        public TraceContextCodec build() {
            return new TraceContextCodec(this);
        }
    }
}

