/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mariadb.jdbc.Identifier;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.MySQLResultSet;
import org.mariadb.jdbc.internal.mysql.MySQLType;

class ShowCreateTableParser {
    ShowCreateTableParser() {
    }

    static int skipWhite(char[] s2, int startPos) {
        for (int i = startPos; i < s2.length; ++i) {
            if (Character.isWhitespace(s2[i])) continue;
            return i;
        }
        return s2.length;
    }

    static int parseIdentifier(char[] s2, int startPos, Identifier identifier) throws ParseException {
        int pos = ShowCreateTableParser.skipWhite(s2, startPos);
        if (s2[pos] != '`') {
            throw new ParseException(new String(s2), pos);
        }
        ++pos;
        StringBuffer sb = new StringBuffer();
        int nQuotes = 0;
        while (pos < s2.length) {
            char ch = s2[pos];
            if (ch == '`') {
                ++nQuotes;
            } else {
                for (int j = 0; j < nQuotes / 2; ++j) {
                    sb.append('`');
                }
                if (nQuotes % 2 == 1) {
                    if (ch == '.') {
                        if (identifier.schema != null) {
                            throw new ParseException(new String(s2), pos);
                        }
                        identifier.schema = sb.toString();
                        return ShowCreateTableParser.parseIdentifier(s2, pos + 1, identifier);
                    }
                    identifier.name = sb.toString();
                    return pos;
                }
                nQuotes = 0;
                sb.append(ch);
            }
            ++pos;
        }
        throw new ParseException(new String(s2), startPos);
    }

    static int parseIdentifierList(char[] s2, int startPos, List<Identifier> list) throws ParseException {
        int pos = ShowCreateTableParser.skipWhite(s2, startPos);
        if (s2[pos] != '(') {
            throw new ParseException(new String(s2), pos);
        }
        ++pos;
        block5: while (true) {
            pos = ShowCreateTableParser.skipWhite(s2, pos);
            char ch = s2[pos];
            switch (ch) {
                case ')': {
                    return pos + 1;
                }
                case '`': {
                    Identifier id = new Identifier();
                    pos = ShowCreateTableParser.parseIdentifier(s2, pos, id);
                    list.add(id);
                    continue block5;
                }
                case ',': {
                    ++pos;
                    continue block5;
                }
            }
            break;
        }
        throw new ParseException(new String(s2, startPos, s2.length - startPos), startPos);
    }

    static int skipKeyword(char[] s2, int startPos, String keyword) throws ParseException {
        int pos = ShowCreateTableParser.skipWhite(s2, startPos);
        int i = 0;
        while (i < keyword.length()) {
            if (s2[pos] != keyword.charAt(i)) {
                throw new ParseException(new String(s2), pos);
            }
            ++i;
            ++pos;
        }
        return pos;
    }

    static int getImportedKeyAction(String s2) {
        if (s2 == null) {
            return 1;
        }
        if (s2.equals("NO ACTION")) {
            return 3;
        }
        if (s2.equals("CASCADE")) {
            return 0;
        }
        if (s2.equals("SET NULL")) {
            return 2;
        }
        if (s2.equals("SET DEFAULT")) {
            return 4;
        }
        if (s2.equals("RESTRICT")) {
            return 1;
        }
        throw new AssertionError((Object)"should not happen");
    }

    public static ResultSet getImportedKeys(String tableDef, String tableName, String catalog, MySQLConnection c) throws ParseException {
        String[] columnNames = new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"};
        MySQLType[] columnTypes = new MySQLType[]{MySQLType.VARCHAR, MySQLType.NULL, MySQLType.VARCHAR, MySQLType.VARCHAR, MySQLType.VARCHAR, MySQLType.NULL, MySQLType.VARCHAR, MySQLType.VARCHAR, MySQLType.SMALLINT, MySQLType.SMALLINT, MySQLType.SMALLINT, MySQLType.VARCHAR, MySQLType.NULL, MySQLType.SMALLINT};
        String[] parts = tableDef.split("\n");
        ArrayList<String[]> data = new ArrayList<String[]>();
        for (String p : parts) {
            if (!(p = p.trim()).startsWith("CONSTRAINT") && !p.contains("FOREIGN KEY")) continue;
            char[] s2 = p.toCharArray();
            Identifier constraintName = new Identifier();
            Identifier pkTable = new Identifier();
            ArrayList<Identifier> foreignKeyCols = new ArrayList<Identifier>();
            ArrayList<Identifier> primaryKeyCols = new ArrayList<Identifier>();
            int pos = ShowCreateTableParser.skipKeyword(s2, 0, "CONSTRAINT");
            pos = ShowCreateTableParser.parseIdentifier(s2, pos, constraintName);
            pos = ShowCreateTableParser.skipKeyword(s2, pos, "FOREIGN KEY");
            pos = ShowCreateTableParser.parseIdentifierList(s2, pos, foreignKeyCols);
            pos = ShowCreateTableParser.skipKeyword(s2, pos, "REFERENCES");
            pos = ShowCreateTableParser.parseIdentifier(s2, pos, pkTable);
            ShowCreateTableParser.parseIdentifierList(s2, pos, primaryKeyCols);
            if (primaryKeyCols.size() != foreignKeyCols.size()) {
                throw new ParseException(tableDef, 0);
            }
            int onUpdateReferenceAction = 1;
            int onDeleteReferenceAction = 1;
            for (String referenceAction : new String[]{"RESTRICT", "CASCADE", "SET NULL", "NO ACTION"}) {
                if (p.contains("ON UPDATE " + referenceAction)) {
                    onUpdateReferenceAction = ShowCreateTableParser.getImportedKeyAction(referenceAction);
                }
                if (!p.contains("ON DELETE " + referenceAction)) continue;
                onDeleteReferenceAction = ShowCreateTableParser.getImportedKeyAction(referenceAction);
            }
            for (int i = 0; i < primaryKeyCols.size(); ++i) {
                String[] row = new String[columnNames.length];
                row[0] = pkTable.schema;
                if (row[0] == null) {
                    row[0] = catalog;
                }
                row[1] = null;
                row[2] = pkTable.name;
                row[3] = ((Identifier)primaryKeyCols.get((int)i)).name;
                row[4] = catalog;
                row[5] = null;
                row[6] = tableName;
                row[7] = ((Identifier)foreignKeyCols.get((int)i)).name;
                row[8] = Integer.toString(i + 1);
                row[9] = Integer.toString(onUpdateReferenceAction);
                row[10] = Integer.toString(onDeleteReferenceAction);
                row[11] = constraintName.name;
                row[12] = null;
                row[13] = Integer.toString(6);
                data.add(row);
            }
        }
        String[][] arr = (String[][])data.toArray((T[])new String[0][]);
        Arrays.sort(arr, new Comparator<String[]>(){

            @Override
            public int compare(String[] row1, String[] row2) {
                int result = row1[0].compareTo(row2[0]);
                if (result == 0 && (result = row1[2].compareTo(row2[2])) == 0 && (result = row1[8].length() - row2[8].length()) == 0) {
                    result = row1[8].compareTo(row2[8]);
                }
                return result;
            }
        });
        ResultSet ret = MySQLResultSet.createResultSet(columnNames, columnTypes, arr, c.getProtocol());
        return ret;
    }
}

