/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import java.sql.SQLTransientException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.mariadb.jdbc.MySQLConnection;
import org.mariadb.jdbc.internal.common.QueryException;

public class SQLExceptionMapper {
    public static void throwException(QueryException e, MySQLConnection connection, Statement statement) throws SQLException {
        SQLException sqlException = SQLExceptionMapper.get(e);
        String sqlState = e.getSqlState();
        SQLStates state = SQLStates.fromString(sqlState);
        if (connection != null) {
            if (state.equals((Object)SQLStates.CONNECTION_EXCEPTION)) {
                connection.setHostFailed();
                if (connection.pooledConnection != null) {
                    connection.pooledConnection.fireConnectionErrorOccured(sqlException);
                }
            } else if (connection.pooledConnection != null && statement != null) {
                connection.pooledConnection.fireStatementErrorOccured(statement, sqlException);
            }
        }
        throw sqlException;
    }

    private static SQLException get(QueryException e) {
        String sqlState = e.getSqlState();
        SQLStates state = SQLStates.fromString(sqlState);
        switch (state) {
            case DATA_EXCEPTION: {
                return new SQLDataException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case FEATURE_NOT_SUPPORTED: {
                return new SQLFeatureNotSupportedException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case CONSTRAINT_VIOLATION: {
                return new SQLIntegrityConstraintViolationException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case INVALID_AUTHORIZATION: {
                return new SQLInvalidAuthorizationSpecException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case CONNECTION_EXCEPTION: {
                return new SQLNonTransientConnectionException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case SYNTAX_ERROR_ACCESS_RULE: {
                return new SQLSyntaxErrorException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case TRANSACTION_ROLLBACK: {
                return new SQLTransactionRollbackException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case WARNING: {
                return new SQLWarning(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case INTERRUPTED_EXCEPTION: {
                return new SQLTransientException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
            case TIMEOUT_EXCEPTION: {
                return new SQLTimeoutException(e.getMessage(), sqlState, e.getErrorCode(), e);
            }
        }
        return new SQLException(e.getMessage(), sqlState, e.getErrorCode(), e);
    }

    public static SQLException getSQLException(String message, Exception e) {
        return new SQLException(message, e);
    }

    public static SQLException getSQLException(String message, String sqlState, Exception e) {
        return new SQLException(message, sqlState, 0, e);
    }

    public static SQLException getSQLException(String message) {
        return new SQLException(message);
    }

    public static SQLException getFeatureNotSupportedException(String message) {
        return new SQLFeatureNotSupportedException(message);
    }

    public static String mapMySQLCodeToSQLState(int code) {
        switch (code) {
            case 1022: {
                return "23000";
            }
            case 1037: {
                return "HY001";
            }
            case 1038: {
                return "HY001";
            }
            case 1040: {
                return "08004";
            }
            case 1042: {
                return "08S01";
            }
            case 1043: {
                return "08S01";
            }
            case 1044: {
                return "42000";
            }
            case 1045: {
                return "28000";
            }
            case 1047: {
                return "HY000";
            }
            case 1050: {
                return "42S01";
            }
            case 1051: {
                return "42S02";
            }
            case 1052: {
                return "23000";
            }
            case 1053: {
                return "08S01";
            }
            case 1054: {
                return "42S22";
            }
            case 1055: {
                return "42000";
            }
            case 1056: {
                return "42000";
            }
            case 1057: {
                return "42000";
            }
            case 1058: {
                return "21S01";
            }
            case 1059: {
                return "42000";
            }
            case 1060: {
                return "42S21";
            }
            case 1061: {
                return "42000";
            }
            case 1062: {
                return "23000";
            }
            case 1063: {
                return "42000";
            }
            case 1064: {
                return "42000";
            }
            case 1065: {
                return "42000";
            }
            case 1066: {
                return "42000";
            }
            case 1067: {
                return "42000";
            }
            case 1068: {
                return "42000";
            }
            case 1069: {
                return "42000";
            }
            case 1070: {
                return "42000";
            }
            case 1071: {
                return "42000";
            }
            case 1072: {
                return "42000";
            }
            case 1073: {
                return "42000";
            }
            case 1074: {
                return "42000";
            }
            case 1075: {
                return "42000";
            }
            case 1080: {
                return "08S01";
            }
            case 1081: {
                return "08S01";
            }
            case 1082: {
                return "42S12";
            }
            case 1083: {
                return "42000";
            }
            case 1084: {
                return "42000";
            }
            case 1090: {
                return "42000";
            }
            case 1091: {
                return "42000";
            }
            case 1101: {
                return "42000";
            }
            case 1102: {
                return "42000";
            }
            case 1103: {
                return "42000";
            }
            case 1104: {
                return "42000";
            }
            case 1106: {
                return "42000";
            }
            case 1107: {
                return "42000";
            }
            case 1109: {
                return "42S02";
            }
            case 1110: {
                return "42000";
            }
            case 1112: {
                return "42000";
            }
            case 1113: {
                return "42000";
            }
            case 1115: {
                return "42000";
            }
            case 1118: {
                return "42000";
            }
            case 1120: {
                return "42000";
            }
            case 1121: {
                return "42000";
            }
            case 1129: {
                return "HY000";
            }
            case 1130: {
                return "HY000";
            }
            case 1131: {
                return "42000";
            }
            case 1132: {
                return "42000";
            }
            case 1133: {
                return "42000";
            }
            case 1136: {
                return "21S01";
            }
            case 1138: {
                return "42000";
            }
            case 1139: {
                return "42000";
            }
            case 1140: {
                return "42000";
            }
            case 1141: {
                return "42000";
            }
            case 1142: {
                return "42000";
            }
            case 1143: {
                return "42000";
            }
            case 1144: {
                return "42000";
            }
            case 1145: {
                return "42000";
            }
            case 1146: {
                return "42S02";
            }
            case 1147: {
                return "42000";
            }
            case 1148: {
                return "42000";
            }
            case 1149: {
                return "42000";
            }
            case 1152: {
                return "08S01";
            }
            case 1153: {
                return "08S01";
            }
            case 1154: {
                return "08S01";
            }
            case 1155: {
                return "08S01";
            }
            case 1156: {
                return "08S01";
            }
            case 1157: {
                return "08S01";
            }
            case 1158: {
                return "08S01";
            }
            case 1159: {
                return "08S01";
            }
            case 1160: {
                return "08S01";
            }
            case 1161: {
                return "08S01";
            }
            case 1162: {
                return "42000";
            }
            case 1163: {
                return "42000";
            }
            case 1164: {
                return "42000";
            }
            case 1166: {
                return "42000";
            }
            case 1167: {
                return "42000";
            }
            case 1169: {
                return "23000";
            }
            case 1170: {
                return "42000";
            }
            case 1171: {
                return "42000";
            }
            case 1172: {
                return "42000";
            }
            case 1173: {
                return "42000";
            }
            case 1177: {
                return "42000";
            }
            case 1178: {
                return "42000";
            }
            case 1179: {
                return "25000";
            }
            case 1184: {
                return "08S01";
            }
            case 1189: {
                return "08S01";
            }
            case 1190: {
                return "08S01";
            }
            case 1203: {
                return "42000";
            }
            case 1205: {
                return "41000";
            }
            case 1207: {
                return "25000";
            }
            case 1211: {
                return "42000";
            }
            case 1213: {
                return "40001";
            }
            case 1216: {
                return "23000";
            }
            case 1217: {
                return "23000";
            }
            case 1218: {
                return "08S01";
            }
            case 1222: {
                return "21000";
            }
            case 1226: {
                return "42000";
            }
            case 1230: {
                return "42000";
            }
            case 1231: {
                return "42000";
            }
            case 1232: {
                return "42000";
            }
            case 1234: {
                return "42000";
            }
            case 1235: {
                return "42000";
            }
            case 1239: {
                return "42000";
            }
            case 1241: {
                return "21000";
            }
            case 1242: {
                return "21000";
            }
            case 1247: {
                return "42S22";
            }
            case 1248: {
                return "42000";
            }
            case 1249: {
                return "01000";
            }
            case 1250: {
                return "42000";
            }
            case 1251: {
                return "08004";
            }
            case 1252: {
                return "42000";
            }
            case 1253: {
                return "42000";
            }
            case 1261: {
                return "01000";
            }
            case 1262: {
                return "01000";
            }
            case 1263: {
                return "01000";
            }
            case 1264: {
                return "01000";
            }
            case 1265: {
                return "01000";
            }
            case 1280: {
                return "42000";
            }
            case 1281: {
                return "42000";
            }
            case 1286: {
                return "42000";
            }
        }
        return null;
    }

    public static enum SQLStates {
        WARNING("01"),
        NO_DATA("02"),
        CONNECTION_EXCEPTION("08"),
        FEATURE_NOT_SUPPORTED("0A"),
        CARDINALITY_VIOLATION("21"),
        DATA_EXCEPTION("22"),
        CONSTRAINT_VIOLATION("23"),
        INVALID_CURSOR_STATE("24"),
        INVALID_TRANSACTION_STATE("25"),
        INVALID_AUTHORIZATION("28"),
        SQL_FUNCTION_EXCEPTION("2F"),
        TRANSACTION_ROLLBACK("40"),
        SYNTAX_ERROR_ACCESS_RULE("42"),
        INVALID_CATALOG("3D"),
        INTERRUPTED_EXCEPTION("70"),
        UNDEFINED_SQLSTATE("HY"),
        TIMEOUT_EXCEPTION("JZ"),
        DISTRIBUTED_TRANSACTION_ERROR("XA");

        private final String sqlStateGroup;

        private SQLStates(String s2) {
            this.sqlStateGroup = s2;
        }

        public static SQLStates fromString(String group) {
            for (SQLStates state : SQLStates.values()) {
                if (!group.startsWith(state.sqlStateGroup)) continue;
                return state;
            }
            return UNDEFINED_SQLSTATE;
        }

        public String getSqlState() {
            return this.sqlStateGroup;
        }
    }
}

