/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.jsonoverlay.JsonOverlay;
import com.networknt.jsonoverlay.Overlay;
import com.networknt.oas.model.OpenApi3;
import com.networknt.oas.model.impl.OpenApi3Impl;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.networknt.status.Status;
import java.util.Objects;
import java.util.Set;

public class SchemaValidator {
    private static final String COMPONENTS_FIELD = "components";
    static final String VALIDATOR_SCHEMA_INVALID_JSON = "ERR11003";
    static final String VALIDATOR_SCHEMA = "ERR11004";
    private final OpenApi3 api;
    private JsonNode jsonNode;
    private final SchemaValidatorsConfig defaultConfig;

    public SchemaValidator() {
        this(null);
    }

    public SchemaValidator(OpenApi3 api) {
        this.api = api;
        this.jsonNode = Overlay.toJson((JsonOverlay)((OpenApi3Impl)api)).get(COMPONENTS_FIELD);
        this.defaultConfig = SchemaValidatorsConfig.builder().typeLoose(true).pathType(PathType.JSON_POINTER).build();
    }

    public Status validate(JsonNode value, JsonNode schema, SchemaValidatorsConfig config) {
        return this.doValidate(value, schema, config, null);
    }

    public Status validate(JsonNode value, JsonNode schema, SchemaValidatorsConfig config, JsonNodePath instanceLocation) {
        return this.doValidate(value, schema, config, instanceLocation);
    }

    public Status validate(JsonNode value, JsonNode schema, String at) {
        JsonNodePath instanceLocation = new JsonNodePath(this.defaultConfig.getPathType());
        if (at != null) {
            instanceLocation = instanceLocation.append(at);
        }
        return this.validate(value, schema, this.defaultConfig, instanceLocation);
    }

    public Status validate(JsonNode value, JsonNode schema, JsonNodePath instanceLocation) {
        return this.doValidate(value, schema, this.defaultConfig, instanceLocation);
    }

    private Status doValidate(JsonNode value, JsonNode schema, SchemaValidatorsConfig config, JsonNodePath instanceLocation) {
        Objects.requireNonNull(schema, "A schema is required");
        if (instanceLocation == null) {
            instanceLocation = new JsonNodePath(config.getPathType());
        }
        Status status = null;
        Set processingReport = null;
        try {
            if (this.jsonNode != null) {
                ((ObjectNode)schema).set(COMPONENTS_FIELD, this.jsonNode);
            }
            JsonSchema jsonSchema = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012).getSchema(schema, config);
            processingReport = jsonSchema.validate(jsonSchema.createExecutionContext(), value, value, instanceLocation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (processingReport != null && !processingReport.isEmpty()) {
            ValidationMessage vm = (ValidationMessage)processingReport.iterator().next();
            status = new Status(VALIDATOR_SCHEMA, new Object[]{vm.getMessage()});
        }
        return status;
    }
}

