/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.customer.domain;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.networknt.saga.customer.domain.Customer;
import com.networknt.saga.customer.domain.CustomerRepository;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCustomerRepository
implements CustomerRepository {
    private static Logger logger = LoggerFactory.getLogger(MapCustomerRepository.class);
    private static Integer expiredInMinutes = 600;
    static Cache<Long, Customer> customers = Caffeine.newBuilder().expireAfterWrite((long)expiredInMinutes.intValue(), TimeUnit.MINUTES).build();

    public Customer save(Customer customer) {
        customer.setId(Long.valueOf(customers.asMap().size()));
        customers.put((Object)customer.getId(), (Object)customer);
        return customer;
    }

    @Override
    public Customer findOne(Long id) {
        Customer customer = (Customer)customers.getIfPresent((Object)id);
        return customer;
    }

    @Override
    public boolean exists(Long id) {
        Customer customer = (Customer)customers.getIfPresent((Object)id);
        return customer != null;
    }

    @Override
    public Map<Long, Customer> findAll() {
        return customers.asMap();
    }

    @Override
    public long count() {
        return customers.asMap().size();
    }

    @Override
    public void delete(Long id) {
        Customer customer = (Customer)customers.getIfPresent((Object)id);
        customers.invalidate((Object)customer);
    }

    @Override
    public void deleteAll() {
        customers.invalidateAll();
    }
}

