/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.customer.service;

import com.networknt.saga.customer.domain.Customer;
import com.networknt.saga.customer.domain.CustomerCreditLimitExceededException;
import com.networknt.saga.customer.domain.CustomerRepository;
import com.networknt.saga.customer.service.CustomerCreditReservationFailed;
import com.networknt.saga.customer.service.CustomerCreditReserved;
import com.networknt.saga.order.saga.participants.ReserveCreditCommand;
import com.networknt.saga.participant.SagaCommandHandlersBuilder;
import com.networknt.tram.command.consumer.CommandHandlerReplyBuilder;
import com.networknt.tram.command.consumer.CommandHandlers;
import com.networknt.tram.command.consumer.CommandMessage;
import com.networknt.tram.message.common.Message;

public class CustomerCommandHandler {
    private CustomerRepository customerRepository;

    public CustomerCommandHandler(CustomerRepository customerRepository) {
        this.customerRepository = customerRepository;
    }

    public CommandHandlers commandHandlerDefinitions() {
        return SagaCommandHandlersBuilder.fromChannel((String)"customerService").onMessage(ReserveCreditCommand.class, this::reserveCredit).build();
    }

    public Message reserveCredit(CommandMessage<ReserveCreditCommand> cm) {
        ReserveCreditCommand cmd = (ReserveCreditCommand)cm.getCommand();
        long customerId = cmd.getCustomerId();
        Customer customer = this.customerRepository.findOne(customerId);
        try {
            customer.reserveCredit(cmd.getOrderId(), cmd.getOrderTotal());
            return CommandHandlerReplyBuilder.withSuccess((Object)new CustomerCreditReserved());
        }
        catch (CustomerCreditLimitExceededException e) {
            return CommandHandlerReplyBuilder.withFailure((Object)new CustomerCreditReservationFailed());
        }
    }
}

