/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.order.domain;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.networknt.saga.order.domain.Order;
import com.networknt.saga.order.domain.OrderRepository;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapOrderRepository
implements OrderRepository {
    private static Logger logger = LoggerFactory.getLogger(MapOrderRepository.class);
    private static AtomicLong atomicOrderId = new AtomicLong(0L);
    private static Integer expiredInMinutes = 600;
    static Cache<Long, Order> orders = Caffeine.newBuilder().expireAfterWrite((long)expiredInMinutes.intValue(), TimeUnit.MINUTES).build();

    public Order save(Order order) {
        order.setId(atomicOrderId.incrementAndGet());
        orders.put((Object)order.getId(), (Object)order);
        return order;
    }

    @Override
    public Order findOne(Long id) {
        Order order = (Order)orders.getIfPresent((Object)id);
        return order;
    }

    @Override
    public boolean exists(Long id) {
        Order order = (Order)orders.getIfPresent((Object)id);
        return order != null;
    }

    @Override
    public Map<Long, Order> findAll() {
        return orders.asMap();
    }

    @Override
    public long count() {
        return orders.asMap().size();
    }

    @Override
    public void delete(Long id) {
        Order order = (Order)orders.getIfPresent((Object)id);
        orders.invalidate((Object)order);
    }

    @Override
    public void delete(Order entity) {
        orders.invalidate((Object)entity);
    }

    @Override
    public void deleteAll() {
        orders.invalidateAll();
    }
}

