/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.customer.domain;

import com.networknt.saga.common.Money;
import com.networknt.saga.customer.domain.CustomerCreditLimitExceededException;
import java.util.HashMap;
import java.util.Map;

public class Customer {
    private Long id;
    private String name;
    private Money creditLimit;
    private Map<Long, Money> creditReservations;

    Money availableCredit() {
        return this.creditLimit.subtract(this.creditReservations.values().stream().reduce(Money.ZERO, Money::add));
    }

    public Customer() {
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Customer(String name, Money creditLimit) {
        this.name = name;
        this.creditLimit = creditLimit;
        this.creditReservations = new HashMap<Long, Money>();
    }

    public Long getId() {
        return this.id;
    }

    public void reserveCredit(Long orderId, Money orderTotal) {
        if (!this.availableCredit().isGreaterThanOrEqual(orderTotal)) {
            throw new CustomerCreditLimitExceededException();
        }
        this.creditReservations.put(orderId, orderTotal);
    }
}

