/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.order.saga.createorder;

import com.networknt.saga.common.Money;
import com.networknt.saga.dsl.SimpleSaga;
import com.networknt.saga.orchestration.SagaDefinition;
import com.networknt.saga.order.saga.createorder.CreateOrderSagaData;
import com.networknt.saga.order.saga.participants.ApproveOrderCommand;
import com.networknt.saga.order.saga.participants.RejectOrderCommand;
import com.networknt.saga.order.saga.participants.ReserveCreditCommand;
import com.networknt.tram.command.common.Command;
import com.networknt.tram.command.consumer.CommandWithDestination;
import com.networknt.tram.command.consumer.CommandWithDestinationBuilder;

public class CreateOrderSaga
implements SimpleSaga<CreateOrderSagaData> {
    private SagaDefinition<CreateOrderSagaData> sagaDefinition = this.step().withCompensation(this::reject).step().invokeParticipant(this::reserveCredit).step().invokeParticipant(this::approve).build();

    public SagaDefinition<CreateOrderSagaData> getSagaDefinition() {
        return this.sagaDefinition;
    }

    private CommandWithDestination reserveCredit(CreateOrderSagaData data) {
        long orderId = data.getOrderId();
        Long customerId = data.getOrderDetails().getCustomerId();
        Money orderTotal = data.getOrderDetails().getOrderTotal();
        return CommandWithDestinationBuilder.send((Command)new ReserveCreditCommand(customerId, orderId, orderTotal)).to("customerService").build();
    }

    public CommandWithDestination reject(CreateOrderSagaData data) {
        return CommandWithDestinationBuilder.send((Command)new RejectOrderCommand(data.getOrderId())).to("orderService").build();
    }

    private CommandWithDestination approve(CreateOrderSagaData data) {
        return CommandWithDestinationBuilder.send((Command)new ApproveOrderCommand(data.getOrderId())).to("orderService").build();
    }
}

