/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.metrics.prometheus;

import com.networknt.config.Config;
import com.networknt.handler.Handler;
import com.networknt.handler.MiddlewareHandler;
import com.networknt.httpstring.AttachmentConstants;
import com.networknt.metrics.prometheus.PrometheusConfig;
import com.networknt.utility.ModuleRegistry;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.SimpleTimer;
import io.prometheus.client.Summary;
import io.prometheus.client.hotspot.DefaultExports;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusHandler
implements MiddlewareHandler {
    public static final String CONFIG_NAME = "prometheus";
    public static PrometheusConfig config = (PrometheusConfig)Config.getInstance().getJsonObjectConfig("prometheus", PrometheusConfig.class);
    private CollectorRegistry registry;
    static final Logger logger = LoggerFactory.getLogger(PrometheusHandler.class);
    private volatile HttpHandler next;
    private final ConcurrentMap<String, Counter> counters = new ConcurrentHashMap<String, Counter>();
    private final ConcurrentMap<String, Summary> response_times = new ConcurrentHashMap<String, Summary>();
    public static final String REQUEST_TOTAL = "requests_total";
    public static final String SUCCESS_TOTAL = "success_total";
    public static final String AUTO_ERROR_TOTAL = "auth_error_total";
    public static final String REQUEST_ERROR_TOTAL = "request_error_total";
    public static final String SERVER_ERROR_TOTAL = "server_error_total";
    public static final String RESPONSE_TIME_SECOND = "response_time_seconds";

    public PrometheusHandler() {
        this.registry = CollectorRegistry.defaultRegistry;
    }

    public HttpHandler getNext() {
        return this.next;
    }

    public MiddlewareHandler setNext(HttpHandler next) {
        Handlers.handlerNotNull((HttpHandler)next);
        this.next = next;
        return this;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SimpleTimer respTimer = new SimpleTimer();
        exchange.addExchangeCompleteListener((exchange1, nextListener) -> {
            try {
                Map auditInfo = (Map)exchange1.getAttachment(AttachmentConstants.AUDIT_INFO);
                if (auditInfo != null) {
                    HashMap<String, String> tags = new HashMap<String, String>();
                    tags.put("endpoint", (String)auditInfo.get("endpoint"));
                    tags.put("clientId", auditInfo.get("client_id") != null ? (String)auditInfo.get("client_id") : "unknown");
                    ArrayList<String> labels = new ArrayList<String>(tags.keySet());
                    ArrayList<String> labelValues = new ArrayList<String>(tags.values());
                    ((Summary.Child)this.summary(RESPONSE_TIME_SECOND, labels).labels((String[])labelValues.stream().toArray(String[]::new))).observe(respTimer.elapsedSeconds());
                    this.incCounterForStatusCode(exchange1.getStatusCode(), labels, labelValues);
                    if (PrometheusHandler.config.enableHotspot) {
                        logger.info("Prometheus hotspot monitor enabled.");
                        DefaultExports.initialize();
                    }
                }
            }
            catch (Throwable e) {
                logger.error("ExchangeListenerThrowable", e);
            }
            finally {
                nextListener.proceed();
            }
        });
        Handler.next((HttpServerExchange)exchange, (HttpHandler)this.next);
    }

    public boolean isEnabled() {
        return config.isEnabled();
    }

    public void register() {
        ModuleRegistry.registerModule((String)PrometheusHandler.class.getName(), (Map)Config.getInstance().getJsonMapConfigNoCache(CONFIG_NAME), null);
    }

    private void incCounterForStatusCode(int statusCode, List<String> labels, List<String> labelValues) {
        ((Counter.Child)this.counter(REQUEST_TOTAL, labels).labels((String[])labelValues.stream().toArray(String[]::new))).inc();
        if (statusCode >= 200 && statusCode < 400) {
            ((Counter.Child)this.counter(SUCCESS_TOTAL, labels).labels((String[])labelValues.stream().toArray(String[]::new))).inc();
        } else if (statusCode == 401 || statusCode == 403) {
            ((Counter.Child)this.counter(AUTO_ERROR_TOTAL, labels).labels((String[])labelValues.stream().toArray(String[]::new))).inc();
        } else if (statusCode >= 400 && statusCode < 500) {
            ((Counter.Child)this.counter(REQUEST_ERROR_TOTAL, labels).labels((String[])labelValues.stream().toArray(String[]::new))).inc();
        } else if (statusCode >= 500) {
            ((Counter.Child)this.counter(SERVER_ERROR_TOTAL, labels).labels((String[])labelValues.stream().toArray(String[]::new))).inc();
        }
    }

    private Counter counter(String name, List<String> labels) {
        String key = this.sanitizeName(name);
        return this.counters.computeIfAbsent(key, k -> (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name(k)).help(k)).labelNames((String[])labels.stream().toArray(String[]::new))).register(this.registry));
    }

    private Summary summary(String name, List<String> labels) {
        String key = this.sanitizeName(name);
        return this.response_times.computeIfAbsent(key, k -> (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(k)).help(k)).labelNames((String[])labels.stream().toArray(String[]::new))).register(this.registry));
    }

    private String sanitizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_:]", "_");
    }
}

