/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.reqtrans;

import com.fasterxml.jackson.core.type.TypeReference;
import com.networknt.config.Config;
import com.networknt.config.ConfigException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestTransformerConfig {
    public static final String CONFIG_NAME = "request-transformer";
    private static final Logger logger = LoggerFactory.getLogger(RequestTransformerConfig.class);
    private static final String ENABLED = "enabled";
    private static final String REQUIRED_CONTENT = "requiredContent";
    private static final String DEFAULT_BODY_ENCODING = "defaultBodyEncoding";
    private static final String APPLIED_PATH_PREFIXES = "appliedPathPrefixes";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    private boolean enabled;
    private boolean requiredContent;
    private String defaultBodyEncoding;
    List<String> appliedPathPrefixes;

    private RequestTransformerConfig() {
        this(CONFIG_NAME);
    }

    private RequestTransformerConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setConfigList();
    }

    public static RequestTransformerConfig load() {
        return new RequestTransformerConfig();
    }

    public static RequestTransformerConfig load(String configName) {
        return new RequestTransformerConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setConfigList();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRequiredContent() {
        return this.requiredContent;
    }

    public String getDefaultBodyEncoding() {
        return this.defaultBodyEncoding;
    }

    public List<String> getAppliedPathPrefixes() {
        return this.appliedPathPrefixes;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            if (object instanceof String) {
                this.enabled = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.enabled = (Boolean)object;
            } else {
                throw new ConfigException("enabled must be a boolean value.");
            }
        }
        if ((object = this.mappedConfig.get(REQUIRED_CONTENT)) != null) {
            if (object instanceof String) {
                this.requiredContent = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.requiredContent = (Boolean)object;
            } else {
                throw new ConfigException("requiredContent must be a boolean value.");
            }
        }
        if ((object = this.mappedConfig.get(DEFAULT_BODY_ENCODING)) != null) {
            this.defaultBodyEncoding = (String)object;
        }
    }

    private void setConfigList() {
        if (this.mappedConfig.get(APPLIED_PATH_PREFIXES) != null) {
            Object object = this.mappedConfig.get(APPLIED_PATH_PREFIXES);
            this.appliedPathPrefixes = new ArrayList<String>();
            if (object instanceof String) {
                String s = (String)object;
                s = s.trim();
                if (logger.isTraceEnabled()) {
                    logger.trace("s = " + s);
                }
                if (s.startsWith("[")) {
                    try {
                        this.appliedPathPrefixes = (List)Config.getInstance().getMapper().readValue(s, (TypeReference)new TypeReference<List<String>>(){});
                    }
                    catch (Exception e) {
                        throw new ConfigException("could not parse the appliedPathPrefixes json with a list of strings.");
                    }
                } else {
                    this.appliedPathPrefixes = Arrays.asList(s.split("\\s*,\\s*"));
                }
            } else if (object instanceof List) {
                List prefixes = (List)object;
                prefixes.forEach(item -> this.appliedPathPrefixes.add((String)item));
            } else {
                throw new ConfigException("appliedPathPrefixes must be a string or a list of strings.");
            }
        }
    }
}

