/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.rule;

import com.networknt.config.Config;
import com.networknt.config.JsonMapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleLoaderConfig {
    private static final Logger logger = LoggerFactory.getLogger(RuleLoaderConfig.class);
    public static final String CONFIG_NAME = "rule-loader";
    public static final String RULE_SOURCE_LIGHT_PORTAL = "light-portal";
    public static final String RULE_SOURCE_CONFIG_FOLDER = "config-folder";
    private static final String ENABLED = "enabled";
    private static final String RULE_SOURCE = "ruleSource";
    private static final String PORTAL_HOST = "portalHost";
    private static final String PORTAL_TOKEN = "portalToken";
    private static final String ENDPOINT_RULES = "endpointRules";
    private Map<String, Object> mappedConfig;
    private final Config config = Config.getInstance();
    boolean enabled;
    String ruleSource;
    String portalHost;
    String portalToken;
    Map<String, Object> endpointRules;

    private RuleLoaderConfig() {
        this(CONFIG_NAME);
    }

    private RuleLoaderConfig(String configName) {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(configName);
        this.setConfigData();
        this.setMapData();
    }

    public static RuleLoaderConfig load() {
        return new RuleLoaderConfig();
    }

    public static RuleLoaderConfig load(String configName) {
        return new RuleLoaderConfig(configName);
    }

    public void reload() {
        this.mappedConfig = this.config.getJsonMapConfigNoCache(CONFIG_NAME);
        this.setConfigData();
        this.setMapData();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getRuleSource() {
        return this.ruleSource;
    }

    public String getPortalHost() {
        return this.portalHost;
    }

    public String getPortalToken() {
        return this.portalToken;
    }

    public Map<String, Object> getEndpointRules() {
        return this.endpointRules;
    }

    public Map<String, Object> getMappedConfig() {
        return this.mappedConfig;
    }

    private void setConfigData() {
        Object object = this.mappedConfig.get(ENABLED);
        if (object != null) {
            if (object instanceof String) {
                this.enabled = Boolean.parseBoolean((String)object);
            } else if (object instanceof Boolean) {
                this.enabled = (Boolean)object;
            } else {
                throw new RuntimeException("enabled must be a boolean value.");
            }
        }
        this.ruleSource = (String)this.mappedConfig.get(RULE_SOURCE);
        this.portalHost = (String)this.mappedConfig.get(PORTAL_HOST);
        this.portalToken = (String)this.mappedConfig.get(PORTAL_TOKEN);
    }

    private void setMapData() {
        if (this.mappedConfig.get(ENDPOINT_RULES) instanceof String) {
            String s = (String)this.mappedConfig.get(ENDPOINT_RULES);
            if (logger.isTraceEnabled()) {
                logger.trace("endpointRules = " + s);
            }
            this.endpointRules = JsonMapper.string2Map((String)s);
        } else if (this.mappedConfig.get(ENDPOINT_RULES) instanceof Map) {
            this.endpointRules = (Map)this.mappedConfig.get(ENDPOINT_RULES);
        } else if (logger.isInfoEnabled()) {
            logger.info("endpointRules missing or wrong type.");
        }
    }
}

