/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.orchestration;

import com.networknt.saga.orchestration.EnlistedAggregate;
import com.networknt.saga.orchestration.EnlistedAggregatesDao;
import com.networknt.service.SingletonServiceFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnlistedAggregatesDaoImpl
implements EnlistedAggregatesDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource = (DataSource)SingletonServiceFactory.getBean(DataSource.class);

    @Override
    public void save(String sagaId, Set<EnlistedAggregate> enlistedAggregates) {
        String psInsert = "INSERT INTO saga_enlisted_aggregates(saga_id, aggregate_type, aggregate_id) values(?,?,?)";
        for (EnlistedAggregate ela : enlistedAggregates) {
            try {
                Connection connection = this.dataSource.getConnection();
                try {
                    PreparedStatement stmt = connection.prepareStatement(psInsert);
                    stmt.setString(1, sagaId);
                    stmt.setString(2, ela.getAggregateClass().getName());
                    stmt.setString(3, ela.getAggregateId().toString());
                    stmt.executeUpdate();
                }
                finally {
                    if (connection == null) continue;
                    connection.close();
                }
            }
            catch (SQLException e) {
                this.logger.error("SqlException:", (Throwable)e);
            }
        }
    }

    @Override
    public Set<EnlistedAggregate> findEnlistedAggregates(String sagaId) {
        return null;
    }

    @Override
    public Set<String> findSagas(Class aggregateType, String aggregateId) {
        String psSelect = "Select saga_id from saga_enlisted_aggregates where aggregate_type = ? AND  aggregate_id = ?";
        HashSet<String> sagas = new HashSet<String>();
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement ps = connection.prepareStatement(psSelect);
            ps.setString(1, aggregateType.getName());
            ps.setString(1, aggregateId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                sagas.add(rs.getString("saga_id"));
            }
        }
        catch (SQLException e) {
            this.logger.error("SqlException:", (Throwable)e);
        }
        return sagas;
    }
}

