/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.orchestration;

import com.networknt.saga.orchestration.EventClassAndAggregateId;
import com.networknt.saga.orchestration.SagaStateMachineAction;
import com.networknt.tram.event.common.DomainEvent;
import com.networknt.tram.event.subscriber.DomainEventEnvelope;
import java.util.function.Function;

public class SagaEventHandler<Data> {
    private final Class<DomainEvent> eventClass;
    private final Function<Data, Long> aggregateIdProvider;
    private final SagaStateMachineAction<Data, DomainEventEnvelope<DomainEvent>> action;

    public SagaEventHandler(Class<DomainEvent> eventClass, Function<Data, Long> aggregateIdProvider, SagaStateMachineAction<Data, DomainEventEnvelope<DomainEvent>> action) {
        this.eventClass = eventClass;
        this.aggregateIdProvider = aggregateIdProvider;
        this.action = action;
    }

    public static <Data> SagaEventHandler make(Class<DomainEvent> eventClass, Function<Data, Long> aggregateIdProvider, SagaStateMachineAction<Data, DomainEventEnvelope<DomainEvent>> eventHandler) {
        return new SagaEventHandler<Data>(eventClass, aggregateIdProvider, eventHandler);
    }

    public EventClassAndAggregateId eventClassAndAggregateId(Data data) {
        return new EventClassAndAggregateId(this.eventClass, this.aggregateIdProvider.apply(data));
    }

    public Class<DomainEvent> getEventClass() {
        return this.eventClass;
    }

    public SagaStateMachineAction<Data, DomainEventEnvelope<DomainEvent>> getAction() {
        return this.action;
    }
}

