/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.participant;

import com.networknt.saga.common.LockTarget;
import com.networknt.saga.common.SagaUnlockCommand;
import com.networknt.saga.participant.SagaCommandHandler;
import com.networknt.saga.participant.SagaLockManager;
import com.networknt.saga.participant.SagaReplyMessage;
import com.networknt.saga.participant.StashMessageRequiredException;
import com.networknt.service.SingletonServiceFactory;
import com.networknt.tram.command.common.ChannelMapping;
import com.networknt.tram.command.consumer.CommandDispatcher;
import com.networknt.tram.command.consumer.CommandHandler;
import com.networknt.tram.command.consumer.CommandHandlers;
import com.networknt.tram.command.consumer.CommandMessage;
import com.networknt.tram.command.consumer.PathVariables;
import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.consumer.MessageConsumer;
import com.networknt.tram.message.producer.MessageBuilder;
import com.networknt.tram.message.producer.MessageProducer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class SagaCommandDispatcher
extends CommandDispatcher {
    private SagaLockManager sagaLockManager = (SagaLockManager)SingletonServiceFactory.getBean(SagaLockManager.class);

    public SagaCommandDispatcher(String commandDispatcherId, CommandHandlers target, ChannelMapping channelMapping, MessageConsumer messageConsumer, MessageProducer messageProducer, SagaLockManager sagaLockManager) {
        super(commandDispatcherId, target, channelMapping, messageConsumer, messageProducer);
        this.sagaLockManager = sagaLockManager;
    }

    public void messageHandler(Message message) {
        System.out.println("Message  -----------------------> " + message.getPayload());
        if (this.isUnlockMessage(message)) {
            String sagaType = this.getSagaType(message);
            String sagaId = this.getSagaId(message);
            String target = message.getRequiredHeader("command_resource");
            this.sagaLockManager.unlock(sagaId, target).ifPresent(m -> super.messageHandler(message));
        } else {
            try {
                super.messageHandler(message);
            }
            catch (StashMessageRequiredException e) {
                String sagaType = this.getSagaType(message);
                String sagaId = this.getSagaId(message);
                String target = e.getTarget();
                this.sagaLockManager.stashMessage(sagaType, sagaId, target, message);
            }
        }
    }

    private String getSagaId(Message message) {
        return message.getRequiredHeader("command_saga_id");
    }

    private String getSagaType(Message message) {
        return message.getRequiredHeader("command_saga_type");
    }

    protected List<Message> invoke(CommandHandler commandHandler, CommandMessage cm, Map<String, String> pathVars) {
        String sagaId;
        String sagaType;
        Message message;
        SagaCommandHandler sch;
        Optional<Object> lockedTarget = Optional.empty();
        if (commandHandler instanceof SagaCommandHandler && (sch = (SagaCommandHandler)commandHandler).getPreLock().isPresent()) {
            LockTarget lockTarget = sch.getPreLock().get().apply(cm, new PathVariables(pathVars));
            message = cm.getMessage();
            sagaType = this.getSagaType(message);
            sagaId = this.getSagaId(message);
            String target = lockTarget.getTarget();
            lockedTarget = Optional.of(target);
            if (!this.sagaLockManager.claimLock(sagaType, sagaId, target)) {
                throw new StashMessageRequiredException(target);
            }
        }
        List messages = super.invoke(commandHandler, cm, pathVars);
        if (lockedTarget.isPresent()) {
            return this.addLockedHeader(messages, (String)lockedTarget.get());
        }
        Optional<LockTarget> lt = this.getLock(messages);
        if (lt.isPresent()) {
            message = cm.getMessage();
            sagaType = this.getSagaType(message);
            if (!this.sagaLockManager.claimLock(sagaType, sagaId = this.getSagaId(message), lt.get().getTarget())) {
                throw new IllegalArgumentException(sagaId + " must be claim locked");
            }
            return this.addLockedHeader(messages, lt.get().getTarget());
        }
        return messages;
    }

    private Optional<LockTarget> getLock(List<Message> messages) {
        return messages.stream().filter(m -> m instanceof SagaReplyMessage && ((SagaReplyMessage)((Object)m)).hasLockTarget()).findFirst().flatMap(m -> ((SagaReplyMessage)((Object)m)).getLockTarget());
    }

    private List<Message> addLockedHeader(List<Message> messages, String lockedTarget) {
        return messages.stream().map(m -> MessageBuilder.withMessage((Message)m).withHeader("saga-locked-target", lockedTarget).build()).collect(Collectors.toList());
    }

    private boolean isUnlockMessage(Message message) {
        return message.getRequiredHeader("command_type").equals(SagaUnlockCommand.class.getName());
    }
}

