/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.saga.participant;

import com.networknt.eventuate.common.impl.JSonMapper;
import com.networknt.saga.participant.SagaLockManager;
import com.networknt.saga.participant.StashedMessage;
import com.networknt.tram.message.common.Message;
import com.networknt.tram.message.producer.MessageBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaLockManagerImpl
implements SagaLockManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private DataSource dataSource;

    public SagaLockManagerImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean claimLock(String sagaType, String sagaId, String target) {
        String psInsert = "INSERT INTO saga_lock_table(target, saga_type, saga_id) VALUES(?, ?,?)";
        while (true) {
            try {
                boolean bl;
                Connection connection;
                while (true) {
                    connection = this.dataSource.getConnection();
                    PreparedStatement stmt = connection.prepareStatement(psInsert);
                    stmt.setString(1, target);
                    stmt.setString(2, sagaType);
                    stmt.setString(3, sagaId);
                    try {
                        stmt.executeUpdate();
                        bl = true;
                        if (connection == null) return bl;
                    }
                    catch (SQLException e) {
                        Optional<String> owningSagaId = this.selectForUpdate(target);
                        if (owningSagaId.isPresent()) {
                            if (owningSagaId.get().equals(sagaId)) {
                                return true;
                            }
                            this.logger.debug("Saga {} {} is blocked by {} which has locked {}", new Object[]{sagaType, sagaId, owningSagaId, target});
                            return false;
                        }
                        this.logger.debug("{}  is repeating attempt to lock {}", (Object)sagaId, (Object)target);
                        continue;
                    }
                    break;
                }
                connection.close();
                return bl;
            }
            catch (SQLException e) {
                this.logger.error("SqlException:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private Optional<String> selectForUpdate(String target) {
        String psSelect = "select saga_id from saga_lock_table WHERE target = ? FOR UPDATE";
        String saga_id = null;
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement ps = connection.prepareStatement(psSelect);
            ps.setString(1, target);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                saga_id = rs.getString("saga_id");
            }
        }
        catch (SQLException e) {
            this.logger.error("SqlException:", (Throwable)e);
        }
        return Optional.ofNullable(saga_id);
    }

    @Override
    public void stashMessage(String sagaType, String sagaId, String target, Message message) {
        this.logger.debug("Stashing message from {} for {} : {}", new Object[]{sagaId, target, message});
        String psInsert = "INSERT INTO saga_stash_table(message_id, target, saga_type, saga_id, message_headers, message_payload) VALUES(?, ?,?, ?, ?, ?)";
        int count = 0;
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(psInsert);
            stmt.setString(1, message.getRequiredHeader("ID"));
            stmt.setString(2, target);
            stmt.setString(3, sagaType);
            stmt.setString(4, sagaType);
            stmt.setString(5, JSonMapper.toJson((Object)message.getHeaders()));
            stmt.setString(6, message.getPayload());
            count = stmt.executeUpdate();
            if (count != 1) {
                this.logger.error("Failed to insert stashMessage: {}", (Object)message.getPayload());
            }
        }
        catch (SQLException e) {
            this.logger.error("SqlException:", (Throwable)e);
        }
    }

    @Override
    public Optional<Message> unlock(String sagaId, String target) {
        Optional<String> owningSagaId = this.selectForUpdate(target);
        if (!owningSagaId.isPresent()) {
            throw new IllegalArgumentException("no saga is for unlock");
        }
        if (!owningSagaId.get().equals(sagaId)) {
            throw new IllegalArgumentException(String.format("Expected owner to be %s but is %s", sagaId, owningSagaId.get()));
        }
        this.logger.debug("Saga {} has unlocked {}", (Object)sagaId, (Object)target);
        List<StashedMessage> stashedMessages = this.getStashedMessages(target);
        if (stashedMessages.isEmpty()) {
            this.assertEqualToOne(this.lockAndstashDelete("delete from saga_lock_table where target = ?", target));
            return Optional.empty();
        }
        StashedMessage stashedMessage = stashedMessages.get(0);
        this.logger.debug("unstashed from {}  for {} : {}", new Object[]{sagaId, target, stashedMessage.getMessage()});
        this.assertEqualToOne(this.stashTableUpdate(stashedMessage.getSagaType(), stashedMessage.getSagaId(), target));
        this.assertEqualToOne(this.lockAndstashDelete("delete from saga_stash_table where message_id = ?", stashedMessage.getMessage().getId()));
        return Optional.of(stashedMessage.getMessage());
    }

    protected List<StashedMessage> getStashedMessages(String target) {
        String psSelect = "select message_id, target, saga_type, saga_id, message_headers, message_payload from saga_stash_table WHERE target = ? ORDER BY message_id LIMIT 1";
        ArrayList<StashedMessage> stashedMessages = new ArrayList<StashedMessage>();
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement ps = connection.prepareStatement(psSelect);
            ps.setString(1, target);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                StashedMessage message = new StashedMessage(rs.getString("saga_type"), rs.getString("saga_id"), MessageBuilder.withPayload((String)rs.getString("message_payload")).withExtraHeaders("", (Map)JSonMapper.fromJson((String)rs.getString("message_headers"), Map.class)).build());
                stashedMessages.add(message);
            }
        }
        catch (SQLException e) {
            this.logger.error("SqlException:", (Throwable)e);
        }
        return stashedMessages;
    }

    protected int lockAndstashDelete(String queryStr, String input) {
        this.logger.debug("delet call  {} for {} ", (Object)queryStr, (Object)input);
        int count = 0;
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(queryStr);
            stmt.setString(1, input);
            count = stmt.executeUpdate();
            if (count != 1) {
                this.logger.error("Failed to update {} for {}", (Object)queryStr, (Object)input);
            }
        }
        catch (SQLException e) {
            this.logger.error("SqlException:", (Throwable)e);
        }
        return count;
    }

    protected int stashTableUpdate(String sagaType, String sagaId, String target) {
        int count = 0;
        String psUpdate = "update saga_lock_table set saga_type = ?, saga_id = ? where target = ?";
        try (Connection connection = this.dataSource.getConnection();){
            PreparedStatement stmt = connection.prepareStatement(psUpdate);
            stmt.setString(1, sagaType);
            stmt.setString(2, sagaId);
            stmt.setString(3, target);
            count = stmt.executeUpdate();
            if (count != 1) {
                this.logger.error("Failed to update saga_lock_table {} ,{}, {}", new Object[]{sagaType, sagaId, target});
            }
        }
        catch (SQLException e) {
            this.logger.error("SqlException:", (Throwable)e);
        }
        return count;
    }

    private void assertEqualToOne(int n) {
        if (n != 1) {
            throw new RuntimeException("Expected to update one row but updated: " + n);
        }
    }
}

