/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.specification;

import com.networknt.config.Config;
import com.networknt.handler.LightHttpHandler;
import com.networknt.specification.SpecificationConfig;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;

public class SpecSwaggerUIHandler
implements LightHttpHandler {
    public static String swaggerUITemplate = "<html>\n<head>\n    <title>OpenAPI Spec</title>\n    <link rel=\"stylesheet\" type=\"text/css\" href=\"https://cdnjs.cloudflare.com/ajax/libs/swagger-ui/3.19.3/swagger-ui.css\">\n</head>\n<body>\n<div id=\"swagger-ui\"></div>\n<script src=\"https://cdnjs.cloudflare.com/ajax/libs/swagger-ui/3.19.3/swagger-ui-bundle.js\"></script>\n<script src=\"https://cdnjs.cloudflare.com/ajax/libs/swagger-ui/3.19.3/swagger-ui-standalone-preset.js\"></script>\n<script>\nwindow.onload = function() {\n\n  const ui = SwaggerUIBundle({\n    url: \"/spec.yaml\",\n    validatorUrl : false,\n    dom_id: '#swagger-ui',\n    deepLinking: true,\n    presets: [\n      SwaggerUIBundle.presets.apis,\n      SwaggerUIStandalonePreset\n    ],\n    plugins: [\n      SwaggerUIBundle.plugins.DownloadUrl\n    ],\n    layout: \"StandaloneLayout\"\n  })\n\n  window.ui = ui\n}\n</script>\n</body>\n</html>";

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SpecificationConfig config = (SpecificationConfig)Config.getInstance().getJsonObjectConfig("specification", SpecificationConfig.class);
        exchange.getResponseHeaders().add(new HttpString("Content-Type"), "text/html");
        exchange.getResponseSender().send(this.getDisplayHtml());
    }

    private String getDisplayHtml() {
        return swaggerUITemplate;
    }
}

